package ru.yandex.autotests.direct.api.campaigns.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 21.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка статусов текстовой кампании после создания")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class CheckStatusesAfterAddTextCampaignTest {
    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;
    private static CampaignFakeInfo campaignFakeInfo;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign());
        campaignFakeInfo = api.userSteps.getDarkSideSteps().getCampaignFakeSteps().fakeGetCampaignParams(id);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("49")
    public void checkStatusModerate() {
        assertThat("у созданной кампании StatusModerate = New",
                campaignFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("50")
    public void checkStatusPostModerate() {
        assertThat("у созданной кампании StatusPostModerate = New",
                campaignFakeInfo.getStatusPostModerate(), equalTo(Status.NEW));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("51")
    public void checkStatusShow() {
        assertThat("у созданной кампании StatusShow = Yes",
                campaignFakeInfo.getStatusShow(), equalTo(Status.YES));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("52")
    public void checkStatusActive() {
        assertThat("у созданной кампании StatusActive = No",
                campaignFakeInfo.getStatusActive(), equalTo(Status.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("53")
    public void checkStatusBsSynced() {
        assertThat("у созданной кампании StatusBsSynced = No",
                campaignFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }
}
