package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 30.09.15.
 * https://st.yandex-team.ru/TESTIRT-7291
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка типа созданной кампании")
@Issue("https://st.yandex-team.ru/DIRECT-43063")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CheckTypeAfterAddTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Parameterized.Parameter(0)
    public CampaignsType type;

    @Parameterized.Parameter(1)
    public CampaignType typeForAdd;

    @Parameterized.Parameters(name = "campaignType = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.text, CampaignType.TEXT},
                {CampaignsType.mobile_content, CampaignType.MOBILE_CONTENT},
                {CampaignsType.dynamic, CampaignType.DYNAMIC},
                {CampaignsType.cpm_banner, CampaignType.CPM_BANNER}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("54")
    public void addCampaign() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultCampaign(typeForAdd)
                        ),
                ExpectedResult.success());
        Long id = addResponse.getAddResults().get(0).getId();

        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        CampaignsRecord campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(id);

        assertThat("кампания создалась с правильным типом", campaignRecord.getType(), equalTo(type));
    }
}
