package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 31.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля ClientInfo. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class ClientInfoValidationNegativeTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String clientInfo;

    @Parameterized.Parameter(2)
    public Notification expectedNotification;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Тег", "</Name>", new Notification(5002, Api5ErrorDetails.CLIENT_NAME_CONTAINS_SPECIAL_CHARACTERS)},
                {"Перенос строки в имени", "name\n",
                        new Notification(5002, Api5ErrorDetails.CLIENT_NAME_CONTAINS_SPECIAL_CHARACTERS)},
                {"Табуляция в имени", "name\t",
                        new Notification(5002, Api5ErrorDetails.CLIENT_NAME_CONTAINS_SPECIAL_CHARACTERS)},
                {"Превышение максимальной длины",
                        RandomStringUtils.randomAlphabetic(CampaignAddItemMap.MAX_CLIENT_INFO_LENGTH + 1),
                        new Notification(5001, Api5ErrorDetails.CLIENT_INFO_LENGTH_EXCEEDED,
                                CampaignAddItemMap.MAX_CLIENT_INFO_LENGTH)},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("55")
    public void addWithClientInfo() {
        //DIRECT-45849
        //DIRECT-45850
        //DIRECT-46135
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem().withClientInfo(clientInfo)
                                .withDefaultTextCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(expectedNotification));
    }
}
