package ru.yandex.autotests.direct.api.campaigns.add;

import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 18.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Пообъектная обработка запроса")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class DiscreteValidationTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final String INVALID_DATE = "date";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("60")
    public void addValidAndInvalidTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultTextCampaign()
                        ),
                ExpectedResult.success(),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                        Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("61")
    public void addInvalidAndValidTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultTextCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                        Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("62")
    public void addTwoInvalidTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultTextCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("63")
    public void addValidAndInvalidMobileAppCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultMobileAppCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultMobileAppCampaign()
                        ),
                ExpectedResult.success(),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("64")
    public void addInvalidAndValidMobileAppCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultMobileAppCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultMobileAppCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("65")
    public void addTwoInvalidMobileAppCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultMobileAppCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultMobileAppCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("66")
    public void addValidAndInvalidDynamicTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultDynamicTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultDynamicTextCampaign()
                        ),
                ExpectedResult.success(),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("67")
    public void addInvalidAndValidDynamicTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultDynamicTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultDynamicTextCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("68")
    public void addTwoInvalidDynamicTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultDynamicTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultDynamicTextCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    public void addValidAndInvalidCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultCpmBannerCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultCpmBannerCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.success());
    }

    @Test
    public void addInvalidAndValidCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultCpmBannerCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultCpmBannerCampaign()
                        ),
                ExpectedResult.success(),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    public void addTwoInvalidCmpBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultCpmBannerCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultCpmBannerCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("69")
    public void addValidTextAndInvalidMobileAppCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultMobileAppCampaign()
                        ),
                ExpectedResult.success(),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("70")
    public void addValidMobileAppAndInvalidTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultMobileAppCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultTextCampaign()
                        ),
                ExpectedResult.success(),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("71")
    public void addValidTextAndInvalidDynamicTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultDynamicTextCampaign()
                        ),
                ExpectedResult.success(),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                        Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    public void addValidCpmBannerAndInvalidTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultCpmBannerCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultTextCampaign()
                        ),
                ExpectedResult.success(),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    public void addValidDynamicTextAndInvalidCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultDynamicTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultCpmBannerCampaign()
                        ),
                ExpectedResult.success(),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                        Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("72")
    public void addInvalidTextAndInvalidMobileAppCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultMobileAppCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    public void addInvalidDynamicTextAndInvalidCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultDynamicTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultCpmBannerCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("73")
    public void addInvalidTextAndInvalidMobileAppAndInvalidDynamicTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultMobileAppCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultDynamicTextCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    public void addInvalidTextAndInvalidMobileAppAndInvalidDynamicTextAndInvalidCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultMobileAppCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultDynamicTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withStartDate(INVALID_DATE)
                                        .withDefaultCpmBannerCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004, Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("74")
    public void addTwoValidCampaignsWithDifferentSetOfFields() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem().withEndDate(DateTime.now().toString("yyyy-MM-dd"))
                                        .withDefaultTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultTextCampaign()
                        ),
                ExpectedResult.success(), ExpectedResult.success());
    }
}
