package ru.yandex.autotests.direct.api.campaigns.add;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 22.03.16.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-52067")
@Features(CampaignsFeatures.ADD)
@Description("Сохранение в базу SSP площадок в поле ExcludedSites")
@Tag(TagDictionary.TRUNK)
public class ExcludedSitesDBTest {
    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final String SSP_PLATFORM_DEFAULT = "Rubicon";
    private static final String SSP_PLATFORM_DOMAIN_FORMAT = "sspplatform.ru";
    private static final String DOMAIN = "qwerty.ru";
    private static final String APP_ID_WITH_HYPHEN_UNDERSCORE_DOT_NUMBER = "ru.t-r-o-n.jc_DreamBook_FREE123";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static CampaignsRecord campaignRecord;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps();
        jooqDbSteps.sspPlatformsSteps().saveSspPlatformsIfNotExist(SSP_PLATFORM_DEFAULT);
        jooqDbSteps.sspPlatformsSteps().saveSspPlatformsIfNotExist(SSP_PLATFORM_DOMAIN_FORMAT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withExcludedSites(SSP_PLATFORM_DEFAULT, DOMAIN, SSP_PLATFORM_DOMAIN_FORMAT,
                                        APP_ID_WITH_HYPHEN_UNDERSCORE_DOT_NUMBER)
                                .withDefaultTextCampaign()
                        ),
                ExpectedResult.success());
        Long id = addResponse.getAddResults().get(0).getId();

        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        campaignRecord = jooqDbSteps.useShard(shard).campaignsSteps().getCampaignById(id);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("77")
    public void addWithExcludedSitesAndCheckSaveOfDontShowColumn() {
        assertThat("верно сохранился домен", campaignRecord.getDontshow(),
                equalTo(String.join(",", DOMAIN, APP_ID_WITH_HYPHEN_UNDERSCORE_DOT_NUMBER.toLowerCase(),
                        SSP_PLATFORM_DOMAIN_FORMAT)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("78")
    public void addWithExcludedSitesAndCheckSaveOfDisabledSsp() {
        assertThat("верно сохранилась SSP площадка", campaignRecord.getDisabledSsp(),
                equalTo(JsonUtils
                        .toStringDisabledHtmlEscaping(new String[]{SSP_PLATFORM_DEFAULT, SSP_PLATFORM_DOMAIN_FORMAT},
                                true)));
    }
}
