package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 04.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля ExcludedSites. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class ExcludedSitesValidationPositiveTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final String DOMAIN = "qwerty.ru";
    private static final String DOMAIN_CYRILIC = "яндекс.ру";
    private static final String SSP_PLATFORM = "Rubicon";
    private static final String SSP_PLATFORM_WITH_SPACE = "Smaato (test)";
    private static final String SSP_PLATFORM_DOMAIN_FORMAT = "sspplatform.ru";
    private static final String APP_ID_WITH_HYPHEN_UNDERSCORE_DOT_NUMBER = "ru.t-r-o-n.jc_DreamBook_FREE123";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] excludedSites;

    @Parameterized.Parameter(2)
    public String[] expectedExcludedSites;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        List<String> maxLengthExcludedSites = new ArrayList<String>();
        for (int i = 0; i < CampaignAddItemMap.MAX_AMOUNT_OF_EXCLUDED_SITES; i++) {
            maxLengthExcludedSites.add(RandomStringUtils.randomAlphabetic(10).toLowerCase() + ".ru");
        }

        Collections.sort(maxLengthExcludedSites);

        List<String> maxLengthExcludedSitesWithSspPlatform = new ArrayList<String>(maxLengthExcludedSites);
        maxLengthExcludedSitesWithSspPlatform
                .set(CampaignAddItemMap.MAX_AMOUNT_OF_EXCLUDED_SITES - 1, SSP_PLATFORM_DOMAIN_FORMAT);
        return Arrays.asList(new Object[][]{
                {"Домен " + DOMAIN, new String[]{DOMAIN}, new String[]{DOMAIN.toLowerCase()}},
                {"Домен с кириллицей " + DOMAIN_CYRILIC, new String[]{DOMAIN_CYRILIC},
                        new String[]{DOMAIN_CYRILIC.toLowerCase()}},
                {"SSP площадка " + SSP_PLATFORM, new String[]{SSP_PLATFORM}, new String[]{SSP_PLATFORM}},
                {"SSP площадка с пробелом " + SSP_PLATFORM_WITH_SPACE, new String[]{SSP_PLATFORM_WITH_SPACE},
                        new String[]{SSP_PLATFORM_WITH_SPACE}},
                {"Максимальное количество доменов", maxLengthExcludedSites.toArray(new String[]{}),
                        maxLengthExcludedSites.toArray(new String[]{})},
                {"Максимальное количество доменов и ssp площадок",
                        maxLengthExcludedSitesWithSspPlatform.toArray(new String[]{}),
                        maxLengthExcludedSitesWithSspPlatform.toArray(new String[]{})},
                {"ID приложения c тире, прочеркиванием, точкой и цифрами" + APP_ID_WITH_HYPHEN_UNDERSCORE_DOT_NUMBER,
                        new String[]{APP_ID_WITH_HYPHEN_UNDERSCORE_DOT_NUMBER},
                        new String[]{APP_ID_WITH_HYPHEN_UNDERSCORE_DOT_NUMBER.toLowerCase()}}
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps();
        jooqDbSteps.sspPlatformsSteps().saveSspPlatformsIfNotExist(SSP_PLATFORM);
        jooqDbSteps.sspPlatformsSteps().saveSspPlatformsIfNotExist(SSP_PLATFORM_WITH_SPACE);
        jooqDbSteps.sspPlatformsSteps().saveSspPlatformsIfNotExist(SSP_PLATFORM_DOMAIN_FORMAT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("81")
    public void addWithExcludedSitesAndCheckSave() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem().withExcludedSites(excludedSites)
                                .withDefaultTextCampaign()
                        ),
                ExpectedResult.success());
        Long id = addResponse.getAddResults().get(0).getId();
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.EXCLUDED_SITES);
        assertThat("поле ExcludedSites сохранилось верно", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withExcludedSites(expectedExcludedSites).getBean()));
    }
}
