package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFundsEnum;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import com.yandex.direct.api.v5.campaigns.CampaignStatusPaymentEnum;
import com.yandex.direct.api.v5.campaigns.CampaignTypeGetEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaigns.PlacementTypesEnum;
import com.yandex.direct.api.v5.campaigns.SmsEventsEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.AttributionModelEnum;
import com.yandex.direct.api.v5.general.CurrencyEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.general.VideoTargetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAssistantMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignFundsParamMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSettingGetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSettingGetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.EmailSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FrequencyCapSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FrequencyCapSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FundsParamMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSettingGetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PlacementTypeArrayMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PlacementTypeItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsArrayMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmsSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingGetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.StatisticsMap;
import ru.yandex.autotests.directapi.model.campaigns.TimeTargetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 12.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Создание и получение кампании с полным набором полей")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@RunWith(Parameterized.class)
public class FullRequestTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public ProtocolType protocolType;

    @Parameterized.Parameters(name = "protocol = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {ProtocolType.JSON},
                {ProtocolType.SOAP}
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("82")
    public void addOneTextCampaign() {
        api.protocol(protocolType);
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                ADD_REQUEST_MAP_TEXT,
                ExpectedResult.success()
        );
        Long id = addResponse.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withAllFieldNames()
                        .withAllTextCampaignFieldNames()
        );

        // TODO DIRECT-169007: после переключения campaigns.get на java
        //                      эту сортировку можно будет убрать (в остальных тестах тоже)
        getResponse.getCampaigns().forEach(c -> {
            c.getTextCampaign()
                    .getSettings()
                    .sort(Comparator.comparing(x -> x.getOption().value()));
        });
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(EXPECTED_TEXT_CAMPAIGN.withId(id).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("83")
    public void addOneMobileAppCampaign() {
        api.protocol(protocolType);
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                ADD_REQUEST_MAP_MOBILE_APP,
                ExpectedResult.success()
        );
        Long id = addResponse.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withAllFieldNames()
                        .withAllMobileAppCampaignFieldNames()
        );

        getResponse.getCampaigns().forEach(c -> {
            c.getMobileAppCampaign()
                    .getSettings()
                    .sort(Comparator.comparing(x -> x.getOption().value()));
        });
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(EXPECTED_MOBILE_APP_CAMPAIGN.withId(id).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("84")
    public void addOneDynamicTextCampaign() {
        api.protocol(protocolType);
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                ADD_REQUEST_MAP_DYNAMIC_TEXT,
                ExpectedResult.success()
        );
        Long id = addResponse.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withAllFieldNames()
                        .withAllDynamicTextCampaignFieldNames()
        );

        getResponse.getCampaigns().forEach(c -> {
            c.getDynamicTextCampaign()
                    .getSettings()
                    .sort(Comparator.comparing(x -> x.getOption().value()));
        });
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(EXPECTED_DYNAMIC_TEXT_CAMPAIGN.withId(id).getBean())));
    }

    @Test
    public void addOneCpmBannerCampaign() {
        api.protocol(protocolType);
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                ADD_REQUEST_MAP_CPM_BANNER,
                ExpectedResult.success()
        );
        Long id = addResponse.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withAllFieldNames()
                        .withAllCpmCampaignFieldNames()
        );

        getResponse.getCampaigns().forEach(c -> {
            c.getCpmBannerCampaign()
                    .getSettings()
                    .sort(Comparator.comparing(x -> x.getOption().value()));
        });
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(EXPECTED_CPM_BANNER_CAMPAIGN.withId(id).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("85")
    public void updateTextCampaignWithOnlyId() {
        //этот тест не в update, чтобы там не дублировать все подготовленные мапы
        //DIRECT-46943
        api.protocol(protocolType);
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                ADD_REQUEST_MAP_TEXT,
                ExpectedResult.success()
        );
        Long id = addResponse.getAddResults().get(0).getId();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)),
                ExpectedResult.success(id));
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withAllFieldNames()
                        .withAllTextCampaignFieldNames()
        );

        getResponse.getCampaigns().forEach(c -> {
            c.getTextCampaign()
                    .getSettings()
                    .sort(Comparator.comparing(x -> x.getOption().value()));
        });
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(EXPECTED_TEXT_CAMPAIGN.withId(id).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("86")
    public void updateMobileAppCampaignWithOnlyId() {
        api.protocol(protocolType);
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                ADD_REQUEST_MAP_MOBILE_APP,
                ExpectedResult.success()
        );
        Long id = addResponse.getAddResults().get(0).getId();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)),
                ExpectedResult.success(id));
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withAllFieldNames()
                        .withAllMobileAppCampaignFieldNames()
        );

        getResponse.getCampaigns().forEach(c -> {
            c.getMobileAppCampaign()
                    .getSettings()
                    .sort(Comparator.comparing(x -> x.getOption().value()));
        });
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(EXPECTED_MOBILE_APP_CAMPAIGN.withId(id).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("87")
    public void updateDynamicTextCampaignWithOnlyId() {
        api.protocol(protocolType);
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                ADD_REQUEST_MAP_DYNAMIC_TEXT,
                ExpectedResult.success()
        );
        Long id = addResponse.getAddResults().get(0).getId();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)),
                ExpectedResult.success(id));
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withAllFieldNames()
                        .withAllDynamicTextCampaignFieldNames()
        );

        getResponse.getCampaigns().forEach(c -> {
            c.getDynamicTextCampaign()
                    .getSettings()
                    .sort(Comparator.comparing(x -> x.getOption().value()));
        });
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(EXPECTED_DYNAMIC_TEXT_CAMPAIGN.withId(id).getBean())));
    }

    @Test
    public void updateCpmBannerCampaignWithOnlyId() {
        api.protocol(protocolType);
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                ADD_REQUEST_MAP_CPM_BANNER,
                ExpectedResult.success()
        );
        Long id = addResponse.getAddResults().get(0).getId();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)),
                ExpectedResult.success(id));
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withAllFieldNames()
                        .withAllCpmCampaignFieldNames()
        );

        getResponse.getCampaigns().forEach(c -> {
            c.getCpmBannerCampaign()
                    .getSettings()
                    .sort(Comparator.comparing(x -> x.getOption().value()));
        });
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(EXPECTED_CPM_BANNER_CAMPAIGN.withId(id).getBean())));
    }

    private static final String CLIENT_INFO = "clientInfo";
    private static final String NAME = "name";

    private static final NotificationMap NOTIFICATION_MAP = new NotificationMap()
            .withEmailSettings(new EmailSettingsMap()
                    .withEmail(EmailSettingsMap.DEFAULT_EMAIL)
                    .withCheckPositionInterval(15)
                    .withWarningBalance(EmailSettingsMap.MIN_WARNING_BALANCE)
                    .withSendAccountNews(YesNoEnum.NO)
                    .withSendWarnings(YesNoEnum.NO))
            .withSmsSettings(new SmsSettingsMap()
                    .withTimeFrom(SmsSettingsMap.VALID_TIME_FROM)
                    .withTimeTo(SmsSettingsMap.VALID_TIME_TO)
                    .withEvents(SmsEventsEnum.FINISHED));

    private static final String START_DATE = DateTime.now().toLocalDate().toString();
    private static final String END_DATE = DateTime.now().plusDays(1).toLocalDate().toString();

    private static final TimeTargetingAddMap TIME_TARGETING_ADD_MAP = new TimeTargetingAddMap()
            .withSchedule(TimeTargetingAddMap.DEFAULT_SCHEDULE)
            .withConsiderWorkingWeekends(YesNoEnum.YES)
            .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                    .withSuspendOnHolidays(YesNoEnum.NO)
                    .withBidPercent(50)
                    .withStartHour(12)
                    .withEndHour(15));

    private static final TimeTargetingAddMap CPM_BANNER_TIME_TARGETING_ADD_MAP = new TimeTargetingAddMap()
            .withSchedule(TimeTargetingAddMap.CPM_BANNER_DEFAULT_SCHEDULE)
            .withConsiderWorkingWeekends(YesNoEnum.YES)
            .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                    .withSuspendOnHolidays(YesNoEnum.NO)
                    .withBidPercent(100)
                    .withStartHour(12)
                    .withEndHour(15));

    private static final TimeTargetingMap TIME_TARGETING_GET_MAP = new TimeTargetingMap()
            .withSchedule(TimeTargetingMap.DEFAULT_SCHEDULE)
            .withConsiderWorkingWeekends(YesNoEnum.YES)
            .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                    .withSuspendOnHolidays(YesNoEnum.NO)
                    .withBidPercent(50)
                    .withStartHour(12)
                    .withEndHour(15));

    private static final TimeTargetingMap CPM_BANNER_TIME_TARGETING_GET_MAP = new TimeTargetingMap()
            .withSchedule(TimeTargetingAddMap.CPM_BANNER_DEFAULT_SCHEDULE)
            .withConsiderWorkingWeekends(YesNoEnum.YES)
            .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                    .withSuspendOnHolidays(YesNoEnum.NO)
                    .withBidPercent(100)
                    .withStartHour(12)
                    .withEndHour(15));

    private static final CpmBannerCampaignStrategyAddMap CPM_BANNER_BIDDING_STRATEGY_ADD_MAP =
            new CpmBannerCampaignStrategyAddMap()
                    .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                    .withNetwork(new CpmBannerCampaignNetworkStrategyAddMap()
                            .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM));

    private static final CpmBannerCampaignStrategyMap CPM_BANNER_BIDDING_STRATEGY_GET_MAP =
            new CpmBannerCampaignStrategyMap()
                    .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                    .withNetwork(new CpmBannerCampaignNetworkStrategyMap()
                            .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM));

    private static final String NEGATIVE_KEYWORDS = "подарки";
    private static final String BLOCKED_IPS = "8.8.8.8";
    private static final String EXCLUDED_SITES = "qwerty.ru";

    private static final DailyBudgetMap DAILY_BUDGET_MAP = new DailyBudgetMap()
            .withAmount(MoneyCurrency.get(Currency.RUB)
                    .getMinDayBudgetAmount().bidLong().longValue())
            .withMode(DailyBudgetModeEnum.STANDARD);

    private static final TextCampaignSettingMap[] TEXT_CAMPAIGN_SETTING_MAPS = {
            new TextCampaignSettingMap()
                    .withOption(TextCampaignSettingsEnum.ADD_TO_FAVORITES)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingMap()
                    .withOption(TextCampaignSettingsEnum.EXCLUDE_PAUSED_COMPETING_ADS)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingMap()
                    .withOption(TextCampaignSettingsEnum.REQUIRE_SERVICING)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingMap()
                    .withOption(TextCampaignSettingsEnum.ADD_OPENSTAT_TAG)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingMap()
                    .withOption(TextCampaignSettingsEnum.ADD_METRICA_TAG)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingMap()
                    .withOption(TextCampaignSettingsEnum.ENABLE_SITE_MONITORING)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingMap()
                    .withOption(TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingMap()
                    .withOption(TextCampaignSettingsEnum.ENABLE_EXTENDED_AD_TITLE)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingMap()
                    .withOption(TextCampaignSettingsEnum.ENABLE_AREA_OF_INTEREST_TARGETING)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingMap()
                    .withOption(TextCampaignSettingsEnum.ENABLE_COMPANY_INFO)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingMap()
                    .withOption(TextCampaignSettingsEnum.CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED)
                    .withValue(YesNoEnum.NO)
    };

    private static final TextCampaignSettingGetMap[] TEXT_CAMPAIGN_SETTING_GET_MAPS = {
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.ADD_METRICA_TAG)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.ADD_OPENSTAT_TAG)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.ADD_TO_FAVORITES)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.DAILY_BUDGET_ALLOWED)
                    .withValue(YesNoEnum.YES),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.ENABLE_AREA_OF_INTEREST_TARGETING)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.ENABLE_COMPANY_INFO)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.ENABLE_EXTENDED_AD_TITLE)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.ENABLE_SITE_MONITORING)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.EXCLUDE_PAUSED_COMPETING_ADS)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.MAINTAIN_NETWORK_CPC)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.REQUIRE_SERVICING)
                    .withValue(YesNoEnum.NO),
            new TextCampaignSettingGetMap()
                    .withOption(TextCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED)
                    .withValue(YesNoEnum.NO),
    };
    private static final MobileAppCampaignSettingMap[] MOBILE_APP_CAMPAIGN_SETTING_MAPS = {
            new MobileAppCampaignSettingMap()
                    .withOption(MobileAppCampaignSettingsEnum.ADD_TO_FAVORITES)
                    .withValue(YesNoEnum.NO),
            new MobileAppCampaignSettingMap()
                    .withOption(MobileAppCampaignSettingsEnum.REQUIRE_SERVICING)
                    .withValue(YesNoEnum.NO),
            new MobileAppCampaignSettingMap()
                    .withOption(MobileAppCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)
                    .withValue(YesNoEnum.NO),
            new MobileAppCampaignSettingMap()
                    .withOption(MobileAppCampaignSettingsEnum.ENABLE_AREA_OF_INTEREST_TARGETING)
                    .withValue(YesNoEnum.NO),
            new MobileAppCampaignSettingMap()
                    .withOption(MobileAppCampaignSettingsEnum.CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED)
                    .withValue(YesNoEnum.NO),
    };

    private static final MobileAppCampaignSettingGetMap[] MOBILE_APP_CAMPAIGN_SETTING_GET_MAPS = {
            new MobileAppCampaignSettingGetMap()
                    .withOption(MobileAppCampaignSettingsGetEnum.ADD_TO_FAVORITES)
                    .withValue(YesNoEnum.NO),
            new MobileAppCampaignSettingGetMap()
                    .withOption(MobileAppCampaignSettingsGetEnum.CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED)
                    .withValue(YesNoEnum.NO),
            new MobileAppCampaignSettingGetMap()
                    .withOption(MobileAppCampaignSettingsGetEnum.DAILY_BUDGET_ALLOWED)
                    .withValue(YesNoEnum.YES),
            new MobileAppCampaignSettingGetMap()
                    .withOption(MobileAppCampaignSettingsGetEnum.ENABLE_AREA_OF_INTEREST_TARGETING)
                    .withValue(YesNoEnum.NO),
            new MobileAppCampaignSettingGetMap()
                    .withOption(MobileAppCampaignSettingsGetEnum.MAINTAIN_NETWORK_CPC)
                    .withValue(YesNoEnum.NO),
            new MobileAppCampaignSettingGetMap()
                    .withOption(MobileAppCampaignSettingsGetEnum.REQUIRE_SERVICING)
                    .withValue(YesNoEnum.NO),
            new MobileAppCampaignSettingGetMap()
                    .withOption(MobileAppCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED)
                    .withValue(YesNoEnum.NO),
    };

    private static final DynamicTextCampaignSettingMap[] DYNAMIC_TEXT_CAMPAIGN_SETTING_MAPS = {
            new DynamicTextCampaignSettingMap()
                    .withOption(DynamicTextCampaignSettingsEnum.ADD_OPENSTAT_TAG)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingMap()
                    .withOption(DynamicTextCampaignSettingsEnum.ADD_METRICA_TAG)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingMap()
                    .withOption(DynamicTextCampaignSettingsEnum.ADD_TO_FAVORITES)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingMap()
                    .withOption(DynamicTextCampaignSettingsEnum.ENABLE_SITE_MONITORING)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingMap()
                    .withOption(DynamicTextCampaignSettingsEnum.REQUIRE_SERVICING)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingMap()
                    .withOption(DynamicTextCampaignSettingsEnum.ENABLE_EXTENDED_AD_TITLE)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingMap()
                    .withOption(DynamicTextCampaignSettingsEnum.ENABLE_AREA_OF_INTEREST_TARGETING)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingMap()
                    .withOption(DynamicTextCampaignSettingsEnum.ENABLE_COMPANY_INFO)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingMap()
                    .withOption(DynamicTextCampaignSettingsEnum.CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED)
                    .withValue(YesNoEnum.NO),
    };

    private static final CpmBannerCampaignSettingMap[] CPM_BANNER_CAMPAIGN_SETTING_MAPS = {
            new CpmBannerCampaignSettingMap()
                    .withOption(CpmBannerCampaignSettingsEnum.ADD_OPENSTAT_TAG)
                    .withValue(YesNoEnum.NO),
            new CpmBannerCampaignSettingMap()
                    .withOption(CpmBannerCampaignSettingsEnum.ADD_METRICA_TAG)
                    .withValue(YesNoEnum.NO),
            new CpmBannerCampaignSettingMap()
                    .withOption(CpmBannerCampaignSettingsEnum.ADD_TO_FAVORITES)
                    .withValue(YesNoEnum.NO),
            new CpmBannerCampaignSettingMap()
                    .withOption(CpmBannerCampaignSettingsEnum.ENABLE_SITE_MONITORING)
                    .withValue(YesNoEnum.NO),
            new CpmBannerCampaignSettingMap()
                    .withOption(CpmBannerCampaignSettingsEnum.REQUIRE_SERVICING)
                    .withValue(YesNoEnum.NO),
            new CpmBannerCampaignSettingMap()
                    .withOption(CpmBannerCampaignSettingsEnum.ENABLE_AREA_OF_INTEREST_TARGETING)
                    .withValue(YesNoEnum.NO),
    };

    private static final Integer COUNTER_IDS = 123;

    private static final DynamicTextCampaignSettingGetMap[] DYNAMIC_TEXT_CAMPAIGN_SETTING_GET_MAPS = {
            new DynamicTextCampaignSettingGetMap()
                    .withOption(DynamicTextCampaignSettingsGetEnum.ADD_METRICA_TAG)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingGetMap()
                    .withOption(DynamicTextCampaignSettingsGetEnum.ADD_OPENSTAT_TAG)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingGetMap()
                    .withOption(DynamicTextCampaignSettingsGetEnum.ADD_TO_FAVORITES)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingGetMap()
                    .withOption(DynamicTextCampaignSettingsGetEnum.CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingGetMap()
                    .withOption(DynamicTextCampaignSettingsGetEnum.DAILY_BUDGET_ALLOWED)
                    .withValue(YesNoEnum.YES),
            new DynamicTextCampaignSettingGetMap()
                    .withOption(DynamicTextCampaignSettingsGetEnum.ENABLE_AREA_OF_INTEREST_TARGETING)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingGetMap()
                    .withOption(DynamicTextCampaignSettingsGetEnum.ENABLE_COMPANY_INFO)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingGetMap()
                    .withOption(DynamicTextCampaignSettingsGetEnum.ENABLE_EXTENDED_AD_TITLE)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingGetMap()
                    .withOption(DynamicTextCampaignSettingsGetEnum.ENABLE_SITE_MONITORING)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingGetMap()
                    .withOption(DynamicTextCampaignSettingsGetEnum.REQUIRE_SERVICING)
                    .withValue(YesNoEnum.NO),
            new DynamicTextCampaignSettingGetMap()
                    .withOption(DynamicTextCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED)
                    .withValue(YesNoEnum.NO),
    };

    private static final CpmBannerCampaignSettingGetMap[] CPM_BANNER_CAMPAIGN_SETTING_GET_MAPS = {
            new CpmBannerCampaignSettingGetMap()
                    .withOption(CpmBannerCampaignSettingsGetEnum.ADD_METRICA_TAG)
                    .withValue(YesNoEnum.NO),
            new CpmBannerCampaignSettingGetMap()
                    .withOption(CpmBannerCampaignSettingsGetEnum.ADD_OPENSTAT_TAG)
                    .withValue(YesNoEnum.NO),
            new CpmBannerCampaignSettingGetMap()
                    .withOption(CpmBannerCampaignSettingsGetEnum.ADD_TO_FAVORITES)
                    .withValue(YesNoEnum.NO),
            new CpmBannerCampaignSettingGetMap()
                    .withOption(CpmBannerCampaignSettingsGetEnum.DAILY_BUDGET_ALLOWED)
                    .withValue(YesNoEnum.YES),
            new CpmBannerCampaignSettingGetMap()
                    .withOption(CpmBannerCampaignSettingsGetEnum.ENABLE_AREA_OF_INTEREST_TARGETING)
                    .withValue(YesNoEnum.NO),
            new CpmBannerCampaignSettingGetMap()
                    .withOption(CpmBannerCampaignSettingsGetEnum.ENABLE_SITE_MONITORING)
                    .withValue(YesNoEnum.NO),
            new CpmBannerCampaignSettingGetMap()
                    .withOption(CpmBannerCampaignSettingsGetEnum.REQUIRE_SERVICING)
                    .withValue(YesNoEnum.NO),
            new CpmBannerCampaignSettingGetMap()
                    .withOption(CpmBannerCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED)
                    .withValue(YesNoEnum.NO),
    };

    private static FrequencyCapSettingAddMap FREQUENCY_CAP_SETTING_ADD_MAP =
            new FrequencyCapSettingAddMap()
                    .withImpressions(10)
                    .withPeriodDays(10);

    private static FrequencyCapSettingMap FREQUENCY_CAP_SETTING_GET_MAP =
            new FrequencyCapSettingMap()
                    .withImpressions(10)
                    .withPeriodDays(10);

    private static final RelevantKeywordsSettingAddMap RELEVANT_KEYWORDS_PARAMS_ADD_MAP =
            new RelevantKeywordsSettingAddMap()
                    .withBudgetPercent(50)
                    .withOptimizeGoalId(0L);

    private static final RelevantKeywordsSettingMap RELEVANT_KEYWORDS_PARAMS_GET_MAP =
            new RelevantKeywordsSettingMap()
                    .withBudgetPercent(50)
                    .withOptimizeGoalId(0L);

    private static final PriorityGoalsArrayMap PRIORITY_GOALS_ADD_MAP =
            new PriorityGoalsArrayMap()
                    .withItems(new PriorityGoalsItemMap()
                            .withEngagedSessionGoalId()
                            .withIsMetrikaSourceOfValue(YesNoEnum.NO)
                            .withValue(100000000L));

    private static final PlacementTypeArrayMap PLACEMENT_TYPE_GET_MAP =
            new PlacementTypeArrayMap()
                    .withItems(new PlacementTypeItemMap()
                                    .withType(PlacementTypesEnum.SEARCH_RESULTS)
                                    .withValue(YesNoEnum.YES),
                            new PlacementTypeItemMap()
                                    .withType(PlacementTypesEnum.PRODUCT_GALLERY)
                                    .withValue(YesNoEnum.YES)
                    );

    private static final AddRequestMap ADD_REQUEST_MAP_TEXT = new AddRequestMap()
            .withCampaigns(new CampaignAddItemMap()
                    .withClientInfo(CLIENT_INFO)
                    .withNotification(NOTIFICATION_MAP)
                    .withEndDate(END_DATE)
                    .withTimeTargeting(TIME_TARGETING_ADD_MAP)
                    .withTimeZone(TimeTargetMap.TimeZone.EUROPE_MOSCOW)
                    .withNegativeKeywords(NEGATIVE_KEYWORDS)
                    .withBlockedIps(BLOCKED_IPS)
                    .withExcludedSites(EXCLUDED_SITES)
                    .withDailyBudget(DAILY_BUDGET_MAP)
                    .withName(NAME)
                    .withStartDate(START_DATE)
                    .withTextCampaign(new TextCampaignAddItemMap()
                            .withSettings(TEXT_CAMPAIGN_SETTING_MAPS)
                            .withCounterIds(COUNTER_IDS)
                            .withRelevantKeywords(RELEVANT_KEYWORDS_PARAMS_ADD_MAP)
                            .withPriorityGoals(PRIORITY_GOALS_ADD_MAP)
                            .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                    .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition())
                                    .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage())))
            );

    private static final AddRequestMap ADD_REQUEST_MAP_MOBILE_APP = new AddRequestMap()
            .withCampaigns(new CampaignAddItemMap()
                    .withClientInfo(CLIENT_INFO)
                    .withNotification(NOTIFICATION_MAP)
                    .withEndDate(END_DATE)
                    .withTimeTargeting(TIME_TARGETING_ADD_MAP)
                    .withTimeZone(TimeTargetMap.TimeZone.EUROPE_MOSCOW)
                    .withNegativeKeywords(NEGATIVE_KEYWORDS)
                    .withBlockedIps(BLOCKED_IPS)
                    .withExcludedSites(EXCLUDED_SITES)
                    .withDailyBudget(DAILY_BUDGET_MAP)
                    .withName(NAME)
                    .withStartDate(START_DATE)
                    .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                            .withSettings(MOBILE_APP_CAMPAIGN_SETTING_MAPS)
                            .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                    .withSearch(new MobileAppCampaignSearchStrategyAddMap().defaultHighestPosition())
                                    .withNetwork(
                                            new MobileAppCampaignNetworkStrategyAddMap().defaultMaximumCoverage())))
            );

    private static final AddRequestMap ADD_REQUEST_MAP_DYNAMIC_TEXT = new AddRequestMap()
            .withCampaigns(new CampaignAddItemMap()
                    .withClientInfo(CLIENT_INFO)
                    .withNotification(NOTIFICATION_MAP)
                    .withEndDate(END_DATE)
                    .withTimeTargeting(TIME_TARGETING_ADD_MAP)
                    .withTimeZone(TimeTargetMap.TimeZone.EUROPE_MOSCOW)
                    .withNegativeKeywords(NEGATIVE_KEYWORDS)
                    .withBlockedIps(BLOCKED_IPS)
                    .withExcludedSites(EXCLUDED_SITES)
                    .withDailyBudget(DAILY_BUDGET_MAP)
                    .withName(NAME)
                    .withStartDate(START_DATE)
                    .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                            .withSettings(DYNAMIC_TEXT_CAMPAIGN_SETTING_MAPS)
                            .withCounterIds(COUNTER_IDS)
                            .withPriorityGoals(PRIORITY_GOALS_ADD_MAP)
                            .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                    .withSearch(new DynamicTextCampaignSearchStrategyAddMap().defaultHighestPosition())
                                    .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff())))
            );

    private static final AddRequestMap ADD_REQUEST_MAP_CPM_BANNER = new AddRequestMap()
            .withCampaigns(new CampaignAddItemMap()
                    .withClientInfo(CLIENT_INFO)
                    .withNotification(NOTIFICATION_MAP)
                    .withEndDate(END_DATE)
                    .withTimeTargeting(TIME_TARGETING_ADD_MAP)
                    .withTimeZone(TimeTargetMap.TimeZone.EUROPE_MOSCOW)
                    .withBlockedIps(BLOCKED_IPS)
                    .withExcludedSites(EXCLUDED_SITES)
                    .withDailyBudget(DAILY_BUDGET_MAP)
                    .withName(NAME)
                    .withTimeTargeting(CPM_BANNER_TIME_TARGETING_ADD_MAP)
                    .withStartDate(START_DATE)
                    .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                            .withSettings(CPM_BANNER_CAMPAIGN_SETTING_MAPS)
                            .withCounterIds(COUNTER_IDS)
                            .withFrequencyCap(FREQUENCY_CAP_SETTING_ADD_MAP)
                            .withBiddingStrategy(CPM_BANNER_BIDDING_STRATEGY_ADD_MAP)));

    private static final CampaignGetItemMap EXPECTED_TEXT_CAMPAIGN =
            new CampaignGetItemMap()
                    .withName(NAME)
                    .withBlockedIps(BLOCKED_IPS)
                    .withCurrency(CurrencyEnum.RUB)
                    .withDailyBudget(DAILY_BUDGET_MAP)
                    .withEndDate(END_DATE)
                    .withExcludedSites(EXCLUDED_SITES)
                    .withFunds(
                            new FundsParamMap()
                                    .withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                                    .withCampaignFunds(
                                            new CampaignFundsParamMap()
                                                    .withBalance(0L)
                                                    .withBalanceBonus(0L)
                                                    .withSum(0L)
                                                    .withSumAvailableForTransfer(0L)
                                    ))
                    .withClientInfo(CLIENT_INFO)
                    .withNegativeKeywords(NEGATIVE_KEYWORDS)
                    .withNotification(NOTIFICATION_MAP)
                    .withRepresentedBy(
                            new CampaignAssistantMap()
                                    .withAgency(null)
                                    .withManager(null)
                    )
                    .withSourceId(null)
                    .withStartDate(START_DATE)
                    .withState(CampaignStateGetEnum.OFF)
                    .withStatistics(new StatisticsMap().withClicks(0L).withImpressions(0L))
                    .withStatus(StatusEnum.DRAFT)
                    .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED)
                    .withStatusClarification(String.format(
                            StatusClarification.DRAFT_WITH_END_DATE.getStatusClarification(),
                            DateTime.parse(END_DATE).toString("dd.MM.yyyy")))
                    .withTimeTargeting(TIME_TARGETING_GET_MAP)
                    .withTimeZone(TimeTargetMap.TimeZone.EUROPE_MOSCOW)
                    .withType(CampaignTypeGetEnum.TEXT_CAMPAIGN)
                    .withTextCampaign(new TextCampaignGetItemMap()
                            .withSettings(TEXT_CAMPAIGN_SETTING_GET_MAPS)
                            .withBiddingStrategy(new TextCampaignStrategyMap()
                                    .withSearch(new TextCampaignSearchStrategyMap().defaultHighestPosition())
                                    .withNetwork(new TextCampaignNetworkStrategyMap().defaultMaximumCoverage()))
                            .withCounterIds(COUNTER_IDS)
                            .withRelevantKeywords(RELEVANT_KEYWORDS_PARAMS_GET_MAP)
                            .withAttributionModel(AttributionModelEnum.LYDCCD)
                            .withPriorityGoals(PRIORITY_GOALS_ADD_MAP));

    private static final CampaignGetItemMap EXPECTED_MOBILE_APP_CAMPAIGN =
            new CampaignGetItemMap()
                    .withName(NAME)
                    .withBlockedIps(BLOCKED_IPS)
                    .withCurrency(CurrencyEnum.RUB)
                    .withDailyBudget(DAILY_BUDGET_MAP)
                    .withEndDate(END_DATE)
                    .withExcludedSites(EXCLUDED_SITES)
                    .withFunds(
                            new FundsParamMap()
                                    .withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                                    .withCampaignFunds(
                                            new CampaignFundsParamMap()
                                                    .withBalance(0L)
                                                    .withBalanceBonus(0L)
                                                    .withSum(0L)
                                                    .withSumAvailableForTransfer(0L)
                                    ))
                    .withClientInfo(CLIENT_INFO)
                    .withNegativeKeywords(NEGATIVE_KEYWORDS)
                    .withNotification(NOTIFICATION_MAP)
                    .withRepresentedBy(
                            new CampaignAssistantMap()
                                    .withAgency(null)
                                    .withManager(null)
                    )
                    .withSourceId(null)
                    .withStartDate(START_DATE)
                    .withState(CampaignStateGetEnum.OFF)
                    .withStatistics(new StatisticsMap().withClicks(0L).withImpressions(0L))
                    .withStatus(StatusEnum.DRAFT)
                    .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED)
                    .withStatusClarification(String.format(
                            StatusClarification.DRAFT_WITH_END_DATE.getStatusClarification(),
                            DateTime.parse(END_DATE).toString("dd.MM.yyyy")))
                    .withTimeTargeting(TIME_TARGETING_GET_MAP)
                    .withTimeZone(TimeTargetMap.TimeZone.EUROPE_MOSCOW)
                    .withType(CampaignTypeGetEnum.MOBILE_APP_CAMPAIGN)
                    .withMobileAppCampaign(new MobileAppCampaignGetItemMap()
                            .withSettings(MOBILE_APP_CAMPAIGN_SETTING_GET_MAPS)
                            .withBiddingStrategy(new MobileAppCampaignStrategyMap()
                                    .withSearch(new MobileAppCampaignSearchStrategyMap().defaultHighestPosition())
                                    .withNetwork(new MobileAppCampaignNetworkStrategyMap().defaultMaximumCoverage())));

    private static final CampaignGetItemMap EXPECTED_DYNAMIC_TEXT_CAMPAIGN =
            new CampaignGetItemMap()
                    .withName(NAME)
                    .withBlockedIps(BLOCKED_IPS)
                    .withCurrency(CurrencyEnum.RUB)
                    .withDailyBudget(DAILY_BUDGET_MAP)
                    .withEndDate(END_DATE)
                    .withExcludedSites(EXCLUDED_SITES)
                    .withFunds(
                            new FundsParamMap()
                                    .withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                                    .withCampaignFunds(
                                            new CampaignFundsParamMap()
                                                    .withBalance(0L)
                                                    .withBalanceBonus(0L)
                                                    .withSum(0L)
                                                    .withSumAvailableForTransfer(0L)
                                    ))
                    .withClientInfo(CLIENT_INFO)
                    .withNegativeKeywords(NEGATIVE_KEYWORDS)
                    .withNotification(NOTIFICATION_MAP)
                    .withRepresentedBy(
                            new CampaignAssistantMap()
                                    .withAgency(null)
                                    .withManager(null)
                    )
                    .withSourceId(null)
                    .withStartDate(START_DATE)
                    .withState(CampaignStateGetEnum.OFF)
                    .withStatistics(new StatisticsMap().withClicks(0L).withImpressions(0L))
                    .withStatus(StatusEnum.DRAFT)
                    .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED)
                    .withStatusClarification(String.format(
                            StatusClarification.DRAFT_WITH_END_DATE.getStatusClarification(),
                            DateTime.parse(END_DATE).toString("dd.MM.yyyy")))
                    .withTimeTargeting(TIME_TARGETING_GET_MAP)
                    .withTimeZone(TimeTargetMap.TimeZone.EUROPE_MOSCOW)
                    .withType(CampaignTypeGetEnum.DYNAMIC_TEXT_CAMPAIGN)
                    .withDynamicTextCampaign(new DynamicTextCampaignGetItemMap()
                            .withSettings(DYNAMIC_TEXT_CAMPAIGN_SETTING_GET_MAPS)
                            .withCounterIds(COUNTER_IDS)
                            .withPriorityGoals(PRIORITY_GOALS_ADD_MAP)
                            .withAttributionModel(AttributionModelEnum.LYDCCD)
                            .withPlacementTypes(PLACEMENT_TYPE_GET_MAP)
                            .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                    .withSearch(new DynamicTextCampaignSearchStrategyMap().defaultHighestPosition())
                                    .withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff())));

    private static final CampaignGetItemMap EXPECTED_CPM_BANNER_CAMPAIGN =
            new CampaignGetItemMap()
                    .withName(NAME)
                    .withBlockedIps(BLOCKED_IPS)
                    .withCurrency(CurrencyEnum.RUB)
                    .withDailyBudget(DAILY_BUDGET_MAP)
                    .withEndDate(END_DATE)
                    .withExcludedSites(EXCLUDED_SITES)
                    .withFunds(
                            new FundsParamMap()
                                    .withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                                    .withCampaignFunds(
                                            new CampaignFundsParamMap()
                                                    .withBalance(0L)
                                                    .withBalanceBonus(0L)
                                                    .withSum(0L)
                                                    .withSumAvailableForTransfer(0L)
                                    ))
                    .withClientInfo(CLIENT_INFO)
                    .withNegativeKeywords((String[]) null)
                    .withNotification(NOTIFICATION_MAP)
                    .withRepresentedBy(
                            new CampaignAssistantMap()
                                    .withAgency(null)
                                    .withManager(null)
                    )
                    .withSourceId(null)
                    .withStartDate(START_DATE)
                    .withState(CampaignStateGetEnum.OFF)
                    .withStatistics(new StatisticsMap().withClicks(0L).withImpressions(0L))
                    .withStatus(StatusEnum.DRAFT)
                    .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED)
                    .withStatusClarification(String.format(
                            StatusClarification.DRAFT_WITH_END_DATE.getStatusClarification(),
                            DateTime.parse(END_DATE).toString("dd.MM.yyyy")))
                    .withTimeTargeting(CPM_BANNER_TIME_TARGETING_GET_MAP)
                    .withTimeZone(TimeTargetMap.TimeZone.EUROPE_MOSCOW)
                    .withType(CampaignTypeGetEnum.CPM_BANNER_CAMPAIGN)
                    .withCpmBannerCampaign(new CpmBannerCampaignGetItemMap()
                            .withSettings(CPM_BANNER_CAMPAIGN_SETTING_GET_MAPS)
                            .withCounterIds(COUNTER_IDS)
                            .withFrequencyCap(FREQUENCY_CAP_SETTING_GET_MAP)
                            .withBiddingStrategy(CPM_BANNER_BIDDING_STRATEGY_GET_MAP)
                            .withVideoTarget(VideoTargetEnum.VIEWS)
                    );
}
