package ru.yandex.autotests.direct.api.campaigns.add;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/DIRECT-78140
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверяем получение ошибки при создании кампании со стратегией IMPRESSIONS_BELOW_SEARCH")
public class ImpressionsBelowSearchStrategyNegativeTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void addTextCampaignWithImpressionsBelowSearchStrategy() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withSearch(new TextCampaignSearchStrategyAddMap().withBiddingStrategyType(
                                                TextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH))
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                ExpectedResult.errorsIgnoringDetails(new Notification(3500, Api5ErrorDetails.STRATEGY_NOT_SUPPORTED,
                        TextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH)));
    }

    @Test
    public void addMobileAppCampaignWithImpressionsBelowSearchStrategy() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                        .withSearch(new MobileAppCampaignSearchStrategyAddMap().withBiddingStrategyType(
                                                MobileAppCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH))
                                        .withNetwork(new MobileAppCampaignNetworkStrategyAddMap().defaultServingOff())))),
                ExpectedResult.errorsIgnoringDetails(new Notification(3500, Api5ErrorDetails.STRATEGY_NOT_SUPPORTED,
                        TextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH)));
    }

    @Test
    public void addDynamicTextCampaignWithImpressionsBelowSearchStrategy() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyAddMap().withBiddingStrategyType(
                                                DynamicTextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH))
                                        .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                ExpectedResult.errorsIgnoringDetails(new Notification(3500, Api5ErrorDetails.STRATEGY_NOT_SUPPORTED,
                        TextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH)));
    }
}
