package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonErrorMatcher;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 21.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка внутренних ролей. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class InternalRolesPositiveTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameter(4)
    public String expectedAgency;

    @Parameterized.Parameter(5)
    public String expectedManager;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"менеджер - сервисируемый клиент",
                        Logins.MANAGER_DEFAULT, CampaignsLogins.SERV_CLIENT,
                        ExpectedResult.success(), null, Logins.MANAGER_DEFAULT},
                {"саппорт - клиент",
                        Logins.SUPPORT, CampaignsLogins.CLIENT,
                        ExpectedResult.success(), null, null},
                //DIRECT-55677
                {"супер - сервисируемый клиент",
                        Logins.SUPER_LOGIN, CampaignsLogins.SERV_CLIENT,
                        ExpectedResult.success(), null, Logins.MANAGER_DEFAULT},
                {"супер - клиент",
                        Logins.SUPER_LOGIN, CampaignsLogins.CLIENT,
                        ExpectedResult.success(), null, null},
                {"менеджер - субклиент",
                        CampaignsLogins.MANAGER_DEFAULT, CampaignsLogins.SUB_CLIENT_WITH_EDIT_RIGHTS,
                        ExpectedResult.success(), CampaignsLogins.AGENCY_CAMPAIGNS, null},
                {"супер - субклиент с правами редактирования",
                        Logins.SUPER_LOGIN, CampaignsLogins.SUB_CLIENT_WITH_EDIT_RIGHTS,
                        ExpectedResult.success(), CampaignsLogins.AGENCY_CAMPAIGNS, null},
                {"супер - субклиент без прав редактирования",
                        Logins.SUPER_LOGIN, CampaignsLogins.SUB_CLIENT_WITHOUT_EDIT_RIGHTS,
                        ExpectedResult.success(), CampaignsLogins.AGENCY_CAMPAIGNS, null}
        };
        return Arrays.asList(data);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("89")
    public void checkRightsToAddCampaign() {
        //DIRECT-45380
        //DIRECT-45381
        //DIRECT-46264
        AddResponse response = api.as(operator).userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultTextCampaign()
                        ),
                client,
                expectedResult
        );

        Long id = response.getAddResults().get(0).getId();

        Long expectedAgencyId = (expectedAgency == null) ? 0L :
                Long.valueOf(api.userSteps.clientFakeSteps().getClientData(expectedAgency).getClientID());
        Long expectedManagerUID = (expectedManager == null) ? null :
                Long.valueOf(api.userSteps.clientFakeSteps().getClientData(expectedManager).getPassportID());

        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        CampaignsRecord campaignRecord = api.userSteps.getDirectJooqDbSteps()
                .useShard(shard).campaignsSteps().getCampaignById(id);

        assertThat("агентство кампании правильное", campaignRecord.getAgencyid(), equalTo(expectedAgencyId));
        assertThat("менеджер кампании правильный", campaignRecord.getManageruid(), equalTo(expectedManagerUID));
    }
}
