package ru.yandex.autotests.direct.api.campaigns.add;

import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.EmailSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmsSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 31.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Неправильный формат запроса")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class InvalidJSONTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String PARAMS = "params";

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("90")
    public void invalidFieldInParams() {
        JsonObject request = new JsonObject().with(AddRequestMap.CAMPAIGNS, new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign().getBean());
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD, PARAMS, AddRequestMap.CAMPAIGNS)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("95")
    public void arrayInParams() {
        AddRequestMap addRequestMap = new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign());
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new Object[]{addRequestMap.getBean()},
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY, PARAMS)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("91")
    public void notArrayInCampaigns() {
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign().getBean());
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(AddRequestMap.CAMPAIGNS))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("92")
    public void invalidFieldInCampaigns() {
        JsonObject campaign = new JsonObject()
                .with(CampaignAddItemMap.CLIENT_INFO, "clientInfo")
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN),
                        new TextCampaignAddItemMap().defaultTextCampaign().getBean());
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        capitalize(AddRequestMap.CAMPAIGNS), CampaignAddItemMap.CLIENT_INFO)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("93")
    public void arrayInNotification() {
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NOTIFICATION),
                        new Object[]{new NotificationMap().defaultNotification().getBean()})
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN),
                        new TextCampaignAddItemMap().defaultTextCampaign().getBean());
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(CampaignAddItemMap.NOTIFICATION))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("94")
    public void invalidFieldInNotification() {
        JsonObject notification = new JsonObject()
                .with(capitalize(NotificationMap.EMAIL_SETTINGS),
                        new EmailSettingsMap().defaultEmailSettings().getBean())
                .with(NotificationMap.SMS_SETTINGS, new SmsSettingsMap().defaultSmsSettings().getBean());
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NOTIFICATION), notification)
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN),
                        new TextCampaignAddItemMap().defaultTextCampaign().getBean());
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD,
                        capitalize(CampaignAddItemMap.NOTIFICATION), NotificationMap.SMS_SETTINGS)
        );
    }
}
