package ru.yandex.autotests.direct.api.campaigns.add;

import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 31.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Неправильные типы в простых полях")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class InvalidTypesOfFieldsTest {
    //Минимальная проверка валидации по wsdl. Проверять все поля нет смысла. По одному кейсу на ошибку

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("99")
    public void arrayInClientInfo() {
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.CLIENT_INFO), new String[]{"clientInfo"})
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN),
                        new TextCampaignAddItemMap().defaultTextCampaign().getBean());
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(CampaignAddItemMap.CLIENT_INFO))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("102")
    public void nullInClientInfo() {
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.CLIENT_INFO), "null")
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN),
                        new TextCampaignAddItemMap().defaultTextCampaign().getBean());
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE, capitalize(CampaignAddItemMap.CLIENT_INFO))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("100")
    public void objectInClientInfo() {
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.CLIENT_INFO), new NotificationMap().defaultNotification().getBean())
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN),
                        new TextCampaignAddItemMap().defaultTextCampaign().getBean());
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_STRING,
                        capitalize(CampaignAddItemMap.CLIENT_INFO))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("101")
    public void stringInDailyBudgetAmount() {
        JsonObject dailyBudget = new JsonObject()
                .with(capitalize(DailyBudgetMap.AMOUNT), "someString")
                .with(capitalize(DailyBudgetMap.MODE), DailyBudgetModeEnum.DISTRIBUTED);
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.DAILY_BUDGET), dailyBudget)
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN),
                        new TextCampaignAddItemMap().defaultTextCampaign().getBean());
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        capitalize(DailyBudgetMap.AMOUNT))
        );
    }
}
