package ru.yandex.autotests.direct.api.campaigns.add;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.SmsEventsEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.EmailSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmsSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.apache.commons.lang3.StringUtils.uncapitalize;

/**
 * Created by pavryabov on 01.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Неправильные значения в полях, принимающих Enum'ы")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
public class InvalidValuesInEnumsTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("103")
    public void invalidValueInSmsSettingsEvents() {
        JsonObject smsSettings = new JsonObject()
                .with(capitalize(SmsSettingsMap.TIME_FROM), SmsSettingsMap.VALID_TIME_FROM)
                .with(capitalize(SmsSettingsMap.TIME_TO), SmsSettingsMap.VALID_TIME_TO)
                .with(capitalize(SmsSettingsMap.EVENTS), new String[]{uncapitalize(SmsEventsEnum.FINISHED.toString())});
        JsonObject notification = new JsonObject()
                .with(capitalize(NotificationMap.EMAIL_SETTINGS),
                        new EmailSettingsMap().defaultEmailSettings().getBean())
                .with(capitalize(NotificationMap.SMS_SETTINGS), smsSettings);
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NOTIFICATION), notification)
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN),
                        new TextCampaignAddItemMap().defaultTextCampaign().getBean());
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(SmsSettingsMap.EVENTS))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("104")
    public void invalidValueInTextCampaignSettingsOption() {
        JsonObject setting = new JsonObject()
                .with(capitalize(TextCampaignSettingMap.OPTION),
                        uncapitalize(TextCampaignSettingsEnum.ADD_TO_FAVORITES.toString()))
                .with(capitalize(TextCampaignSettingMap.VALUE), YesNoEnum.NO);
        JsonObject textCampaign = new JsonObject()
                .with(capitalize(TextCampaignAddItemMap.SETTINGS), new Object[]{setting})
                .with(capitalize(TextCampaignAddItemMap.BIDDING_STRATEGY),
                        new TextCampaignStrategyAddMap().defaultTextCampaignStrategy().getBean());
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN), textCampaign);
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                        capitalize(TextCampaignSettingMap.OPTION))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("105")
    public void invalidValueInTextCampaignSearchStrategyName() {
        JsonObject searchStrategy = new JsonObject()
                .with(capitalize(TextCampaignSearchStrategyAddMap.BIDDING_STRATEGY_TYPE),
                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE);
        JsonObject strategy = new JsonObject()
                .with(capitalize(TextCampaignStrategyAddMap.SEARCH), searchStrategy)
                .with(capitalize(TextCampaignStrategyAddMap.NETWORK),
                        new TextCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE)
                                .getBean());
        JsonObject textCampaign = new JsonObject()
                .with(capitalize(TextCampaignAddItemMap.BIDDING_STRATEGY), strategy);
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN), textCampaign);
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                        capitalize(TextCampaignSearchStrategyAddMap.BIDDING_STRATEGY_TYPE))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("106")
    public void invalidValueInTextCampaignNetworkStrategyName() {
        JsonObject networkStrategy = new JsonObject()
                .with(capitalize(TextCampaignNetworkStrategyAddMap.BIDDING_STRATEGY_TYPE),
                        TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION);
        JsonObject strategy = new JsonObject()
                .with(capitalize(TextCampaignStrategyAddMap.SEARCH),
                        new TextCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION).getBean())
                .with(capitalize(TextCampaignStrategyAddMap.NETWORK), networkStrategy);
        JsonObject textCampaign = new JsonObject()
                .with(capitalize(TextCampaignAddItemMap.BIDDING_STRATEGY), strategy);
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN), textCampaign);
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                        capitalize(TextCampaignNetworkStrategyAddMap.BIDDING_STRATEGY_TYPE))
        );
    }

    @Test
    public void invalidValueInCpmBannerCampaignNetworkStrategyName() {
        JsonObject networkStrategy = new JsonObject()
                .with(capitalize(CpmBannerCampaignNetworkStrategyAddMap.BIDDING_STRATEGY_TYPE),
                        CpmBannerCampaignSearchStrategyTypeEnum.SERVING_OFF);
        JsonObject strategy = new JsonObject()
                .with(capitalize(TextCampaignStrategyAddMap.SEARCH),
                        new CpmBannerCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(CpmBannerCampaignSearchStrategyTypeEnum.SERVING_OFF).getBean())
                .with(capitalize(TextCampaignStrategyAddMap.NETWORK), networkStrategy);
        JsonObject cpmBannerCampaign = new JsonObject()
                .with(capitalize(CpmBannerCampaignAddItemMap.BIDDING_STRATEGY), strategy);
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.CPM_BANNER_CAMPAIGN), cpmBannerCampaign);
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.BIDDING_STRATEGY_TYPE))
        );
    }

    @Test
    public void invalidValueInCpmBannerCampaignSearchStrategyName() {
        JsonObject searchStrategy = new JsonObject()
                .with(capitalize(CpmBannerCampaignNetworkStrategyAddMap.BIDDING_STRATEGY_TYPE),
                        CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM);
        JsonObject strategy = new JsonObject()
                .with(capitalize(TextCampaignStrategyAddMap.NETWORK),
                        new CpmBannerCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM).getBean())
                .with(capitalize(TextCampaignStrategyAddMap.SEARCH), searchStrategy);

        JsonObject cpmBannerCampaign = new JsonObject()
                .with(capitalize(CpmBannerCampaignAddItemMap.BIDDING_STRATEGY), strategy);
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.CPM_BANNER_CAMPAIGN), cpmBannerCampaign);
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.BIDDING_STRATEGY_TYPE))
        );
    }

    @Test
    public void invalidValueInCpmBannerCampaignSettingsOption() {
        JsonObject setting = new JsonObject()
                .with(capitalize(TextCampaignSettingMap.OPTION),
                        uncapitalize(CpmBannerCampaignSettingsEnum.ADD_TO_FAVORITES.toString()))
                .with(capitalize(TextCampaignSettingMap.VALUE), YesNoEnum.NO);

        JsonObject textCampaign = new JsonObject()
                .with(capitalize(TextCampaignAddItemMap.SETTINGS), new Object[]{setting})
                .with(capitalize(TextCampaignAddItemMap.BIDDING_STRATEGY),
                        new CpmBannerCampaignStrategyAddMap().defaultCpmBannerCampaignStrategy().getBean());
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.CPM_BANNER_CAMPAIGN), textCampaign);
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                        capitalize(TextCampaignSettingMap.OPTION))
        );
    }
}
