package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 31.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля Name. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class NameValidationNegativeTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String name;

    @Parameterized.Parameter(2)
    public Notification expectedNotification;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        String maxLengthName = RandomStringUtils.randomAlphabetic(CampaignAddItemMap.MAX_NAME_LENGTH);
        return Arrays.asList(new Object[][]{
                {"Пустая строка", "",
                        new Notification(5003, Api5ErrorDetails.CAMPAIGN_NAME_IS_EMPTY)},
                {"Только пробел", " ",
                        new Notification(5003, Api5ErrorDetails.CAMPAIGN_NAME_IS_EMPTY)},
                {"Тег", "</Name>", new Notification(5002, Api5ErrorDetails.CAMPAIGNS_NAME_CONTAINS_SPECIAL_CHARACTERS)},
                {"Имя длиннее максимальной длины", maxLengthName + "f",
                        new Notification(5001, Api5ErrorDetails.CAMPAIGN_NAME_LENGTH_EXCEEDED,
                                CampaignAddItemMap.MAX_NAME_LENGTH)}
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("107")
    public void addWithName() {
        //DIRECT-45849
        //DIRECT-46135
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem().withName(name)
                                .withDefaultTextCampaign()
                        ),
                ExpectedResult.errorsIgnoringDetails(expectedNotification));
    }
}
