package ru.yandex.autotests.direct.api.campaigns.add;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 31.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля Name. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class NameValidationPositiveTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String name;

    @Parameterized.Parameter(2)
    public String expectedName;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() throws UnsupportedEncodingException {
        String maxLengthName = RandomStringUtils.randomAlphabetic(CampaignAddItemMap.MAX_NAME_LENGTH);
        return Arrays.asList(new Object[][]{
                {"Русское имя с пробелом", "Русское имя с пробелом", "Русское имя с пробелом"},
                {"English name with space", "English name with space", "English name with space"},
                {"Турецкое имя", "müthişreklamÇĞğÖŞÜ", "müthişreklamÇĞğÖŞÜ"},
                {"Украинское имя", "Горілка", "Горілка"},
                {"Казахское имя", "арақ", "арақ"},
                {"Один символ", "н", "н"},
                {"Знак препинания", ".", "."},
                {"кодировка cp1251", new String(new String("Имя").getBytes("UTF-8"), "Cp1251"),
                        new String(new String("Имя").getBytes("UTF-8"), "Cp1251")},
                {"Цифры", "123", "123"},
                {"Перенос строки в имени ", "name\n", "name\n"},
                {"Экранированный перенос строки в имени", "name\\n", "name\\n"},
                {"Имя с кавычкой", "name\"", "name\""},
                {"Имя максимальной длины", maxLengthName, maxLengthName},
                {"Иероглифы", "サムライ", "サムライ"},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("108")
    public void addWithNameAndCheckSave() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem().withName(name)
                                .withDefaultTextCampaign()
                        ),
                ExpectedResult.success());
        Long id = addResponse.getAddResults().get(0).getId();
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.NAME);
        assertThat("поле Name сохранилось верно", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withName(expectedName).getBean()));
    }
}
