package ru.yandex.autotests.direct.api.campaigns.add;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 03.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка обязательности указания полей")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class RequiredFieldsTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("112")
    public void negativeKeywordsWithoutItems() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withNegativeKeywords(new ArrayOfStringMap())
                        .withDefaultTextCampaign()),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CampaignAddItemMap.NEGATIVE_KEYWORDS),
                        capitalize(ArrayOfStringMap.ITEMS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("110")
    public void campaignWithoutName() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withName(null)
                        .withDefaultTextCampaign()),
                new Api5Error(8000, Api5ErrorDetails.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.CAMPAIGNS),
                        capitalize(CampaignAddItemMap.NAME)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("111")
    public void campaignsWithoutStartDate() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withStartDate(null)
                        .withDefaultTextCampaign()),
                new Api5Error(8000, Api5ErrorDetails.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.CAMPAIGNS),
                        capitalize(CampaignAddItemMap.START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("113")
    public void textCampaignWithoutStrategy() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap())),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CampaignAddItemMap.TEXT_CAMPAIGN),
                        capitalize(TextCampaignAddItemMap.BIDDING_STRATEGY)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("114")
    public void textCampaignStrategyWithoutSearch() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withNetwork(
                                                new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault())))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(TextCampaignAddItemMap.BIDDING_STRATEGY),
                        capitalize(TextCampaignStrategyAddMap.SEARCH)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("115")
    public void textCampaignStrategyWithoutNetwork() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition())))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(TextCampaignAddItemMap.BIDDING_STRATEGY),
                        capitalize(TextCampaignStrategyAddMap.NETWORK)));
    }

    @Test
    public void cpmBannerStrategyWithoutSearch() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM))))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(TextCampaignAddItemMap.BIDDING_STRATEGY),
                        capitalize(TextCampaignStrategyAddMap.SEARCH)));
    }

    @Test
    public void cpmBannerStrategyWithoutNetwork() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(TextCampaignAddItemMap.BIDDING_STRATEGY),
                        capitalize(TextCampaignStrategyAddMap.NETWORK)));
    }
}
