package ru.yandex.autotests.direct.api.campaigns.add.contentpromotion;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.GetResponse;
import com.yandex.direct.api.v5.general.AttributionModelEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 5.09.19.
 *https://st.yandex-team.ru/DIRECT-99821
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-99821")
@Features(CampaignsFeatures.ADD)
@Description("Проверка поля AttributionModel")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AttributionModelAddAndGetTest {
    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Parameterized.Parameter(0)
    public AttributionModelEnum initialAttributionModel;

    @Parameterized.Parameters(name = "AttributionModel = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {AttributionModelEnum.FC},
                {AttributionModelEnum.LC},
                {AttributionModelEnum.LSC},
                {AttributionModelEnum.LYDC},
                {AttributionModelEnum.FCCD},
                {AttributionModelEnum.LSCCD},
                {AttributionModelEnum.LYDCCD},
                {null},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        
        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        Long clientId = Long.parseLong(User.get(CLIENT).getClientID());
        dbSteps.featuresSteps().ensureClientHasFeatureIfNotSet(clientId, "cross_device_attribution_types");
    }

    @Before
    public void prepare() {
        campaignId = api.userSteps.campExtSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withContentPromotionCampaign( new ContentPromotionCampaignAddItemMap()
                                .defaultContentPromotionCampaign()
                                .withAttributionModel(initialAttributionModel)));
    }

    @Test
    public void checkCampaignAttributionModel() {

        GetResponse getResponse = api.userSteps.campExtSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                        new CampaignsSelectionCriteriaMap()
                                .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withContentPromotionCampaignFieldNames(ContentPromotionCampaignFieldEnum.ATTRIBUTION_MODEL));

        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));
        AttributionModelEnum attributionModel = getResponse.getCampaigns().get(0).getContentPromotionCampaign().getAttributionModel();
        assumeThat("получили attributionModel", attributionModel, notNullValue());

        assertThat("модель атрибуции соответствует ожиданиям", attributionModel,
                equalTo((initialAttributionModel != null) ? initialAttributionModel : AttributionModelEnum.LYDCCD));
    }

}
