package ru.yandex.autotests.direct.api.campaigns.add.contentpromotion.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.CampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 19.11.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Позитивные сценарии создания мобильной кампании с ручными стратегиями для Search и комбинациями стратегий для Network")
@Tag(TagDictionary.TRUNK)
public class StrategyCombinationsManualSearchTest {
    private static final String client = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public ContentPromotionCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public ContentPromotionCampaignNetworkStrategyAddMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public ContentPromotionCampaignSearchStrategyMap expectedSearchStrategy;

    @Parameterized.Parameter(value = 4)
    public ContentPromotionCampaignNetworkStrategyMap expectedNetworkStrategy;

    @Parameterized.Parameters(name = "Strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-45770, DIRECT-46790
                {"HighestPosition + ServingOff",
                        new ContentPromotionCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new ContentPromotionCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new ContentPromotionCampaignSearchStrategyMap().defaultHighestPosition(),
                        new ContentPromotionCampaignNetworkStrategyMap().defaultServingOff()}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("131")
    public void strategyCombinationTest() {
        List<Long> ids = api.userSteps.campExtSteps().campaignsAddWithCheck(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withContentPromotionCampaign(new ContentPromotionCampaignAddItemMap()
                        .withBiddingStrategy(new ContentPromotionCampaignStrategyAddMap()
                                .withSearch(searchStrategy)
                                .withNetwork(networkStrategy))));
        assumeThat("создана кампания", ids, hasSize(1));

        List<CampaignGetItem> campaigns = api.userSteps.campExtSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(ids.get(0)))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withContentPromotionCampaignFieldNames(ContentPromotionCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        ContentPromotionCampaignStrategy actualStrategy = campaigns.get(0).getContentPromotionCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        ContentPromotionCampaignStrategyMap expectedStrategy = new ContentPromotionCampaignStrategyMap()
                .withSearch(expectedSearchStrategy)
                .withNetwork(expectedNetworkStrategy);

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((ContentPromotionCampaignStrategy) expectedStrategy.getBean()));
    }
}
