package ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign;

import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FrequencyCapSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-83722")
@Features(CampaignsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Проверка возможности задавать ограничение частоты показов (FrequencyCap) в медийной кампании")
public class AddFrequencyCapTest {

    public static final int IMPRESSIONS = 11;
    public static final int PERIOD_DAYS = 8;

    public static final int MIN_IMPRESSIONS = 1;
    public static final int MAX_IMPRESSIONS = 50;

    public static final int MIN_PERIOD_DAYS = 1;
    public static final int MAX_PERIOD_DAYS = 30;

    private static String client = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    public void addWithOnlyImpressionsFieldIsSetTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign()
                                .withFrequencyCap(new FrequencyCapSettingAddMap()
                                        .withImpressions(IMPRESSIONS)))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignAddItemMap.FREQUENCY_CAP),
                        capitalize(FrequencyCapSettingAddMap.PERIOD_DAYS)));
    }

    @Test
    public void addWithMinImpressions() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign()
                                .withFrequencyCap(new FrequencyCapSettingAddMap()
                                        .withImpressions(MIN_IMPRESSIONS)
                                        .withPeriodDays(PERIOD_DAYS)))),
                ExpectedResult.success());
    }

    @Test
    public void addWithMaxImpressions() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign()
                                .withFrequencyCap(new FrequencyCapSettingAddMap()
                                        .withImpressions(MAX_IMPRESSIONS)
                                        .withPeriodDays(PERIOD_DAYS)))),
                ExpectedResult.success());
    }

    @Test
    public void addWithMinPeriodDays() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign()
                                .withFrequencyCap(new FrequencyCapSettingAddMap()
                                        .withImpressions(IMPRESSIONS)
                                        .withPeriodDays(MIN_PERIOD_DAYS)))),
                ExpectedResult.success());
    }

    @Test
    public void addWithMaxPeriodDays() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign()
                                .withFrequencyCap(new FrequencyCapSettingAddMap()
                                        .withImpressions(IMPRESSIONS)
                                        .withPeriodDays(MAX_PERIOD_DAYS)))),
                ExpectedResult.success());
    }

    @Test
    public void addWithMaxImpressionPlusOne() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign()
                                .withFrequencyCap(new FrequencyCapSettingAddMap()
                                        .withImpressions(MAX_IMPRESSIONS + 1)
                                        .withPeriodDays(PERIOD_DAYS)))),
                ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                        Api5ErrorDetails.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                        capitalize(FrequencyCapSettingAddMap.IMPRESSIONS), MIN_IMPRESSIONS, MAX_IMPRESSIONS)));
    }

    @Test
    public void addWithMinPeriodDaysMinusOne() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign()
                                .withFrequencyCap(new FrequencyCapSettingAddMap()
                                        .withImpressions(IMPRESSIONS)
                                        .withPeriodDays(MIN_PERIOD_DAYS - 1)))),
                ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                        Api5ErrorDetails.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                        capitalize(FrequencyCapSettingAddMap.PERIOD_DAYS), MIN_PERIOD_DAYS, MAX_PERIOD_DAYS)));
    }

    @Test
    public void addWithMaxPeriodDaysPlusOne() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign()
                                .withFrequencyCap(new FrequencyCapSettingAddMap()
                                        .withImpressions(IMPRESSIONS)
                                        .withPeriodDays(MAX_PERIOD_DAYS + 1)))),
                ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                        Api5ErrorDetails.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                        capitalize(FrequencyCapSettingAddMap.PERIOD_DAYS), MIN_PERIOD_DAYS, MAX_PERIOD_DAYS)));
    }

    @Test
    public void addWithMinImpressionsMinusOne() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign()
                                .withFrequencyCap(new FrequencyCapSettingAddMap()
                                        .withImpressions(MIN_IMPRESSIONS - 1)
                                        .withPeriodDays(PERIOD_DAYS)))),
                ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                        Api5ErrorDetails.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                        capitalize(FrequencyCapSettingAddMap.IMPRESSIONS), MIN_IMPRESSIONS, MAX_IMPRESSIONS)));
    }

    @Test
    public void addWithNullPeriodDays() {
        JsonObject request = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.CPM_BANNER_CAMPAIGN),
                        new JsonObject()
                                .with(capitalize(CpmBannerCampaignAddItemMap.BIDDING_STRATEGY),
                                        new CpmBannerCampaignStrategyAddMap()
                                                .defaultCpmBannerCampaignStrategy()
                                                .getBean())
                                .with(capitalize(CpmBannerCampaignAddItemMap.FREQUENCY_CAP),
                                        new JsonObject()
                                                .with(capitalize(FrequencyCapSettingAddMap.IMPRESSIONS), IMPRESSIONS)
                                                .with(capitalize(FrequencyCapSettingAddMap.PERIOD_DAYS), "null")));


        api.userSteps.campaignSteps().shouldGetResultOnAdd(new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS),
                new Object[] {request}), ExpectedResult.success());
    }
}
