package ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.general.VideoTargetEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-160096")
@Features(CampaignsFeatures.ADD)
@Description("Проверка возможности задавать VideoTarget в медийной кампании")
@RunWith(Parameterized.class)
public class AddVideoTargetTest {

    private static String client = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public VideoTargetEnum inputVideoTarget;

    @Parameterized.Parameter(1)
    public VideoTargetEnum expectedVideoTarget;

    @Parameterized.Parameters(name = "{0} -> {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {null, VideoTargetEnum.VIEWS},
                {VideoTargetEnum.VIEWS, VideoTargetEnum.VIEWS},
                {VideoTargetEnum.CLICKS, VideoTargetEnum.CLICKS},
        });
    }

    @Test
    public void addWithVideoTarget() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign()
                                .withVideoTarget(inputVideoTarget))),
                ExpectedResult.success());

        Long id = addResponse.getAddResults().get(0).getId();

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withAllFieldNames()
                        .withAllCpmCampaignFieldNames()
        );

        assertThat("вернулась правильное значение VideoTarget",
                getResponse.getCampaigns().get(0).getCpmBannerCampaign().getVideoTarget().getValue(),
                equalTo(expectedVideoTarget));
    }

}
