package ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля CounterIds. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-84939")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CounterIdsValidationPositiveTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Integer[] counterIds;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Integer counterId = RandomUtils.getRandomInteger(1, 1000000);
        List<Integer> maxLengthCounterIds = new ArrayList<Integer>();
        for (int i = 0; i < TextCampaignAddItemMap.MAX_AMOUNT_OF_COUNTER_IDS; i++) {
            maxLengthCounterIds.add(RandomUtils.getRandomInteger(1, 1000000));
        }
        return Arrays.asList(new Object[][]{
                {String.valueOf(counterId), new Integer[]{counterId}},
                {"Максимальное количество элементов", maxLengthCounterIds.toArray(new Integer[]{})},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void addWithCounterIdsAndCheckSave() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                        .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap().defaultCpmBannerCampaignStrategy())
                                        .withCounterIds(counterIds))

                        ),
                ExpectedResult.success());
        Long id = addResponse.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withCpmBannerCampaignFieldNames(CpmBannerCampaignFieldEnum.COUNTER_IDS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), hasSize(1));
        CampaignGetItem campaignGetItem = getResponse.getCampaigns().get(0);
        assertThat("поле CounterIds сохранилось верно", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withCpmBannerCampaign(new CpmBannerCampaignGetItemMap()
                                        .withCounterIds(counterIds)).getBean()));
    }
}
