package ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign;

import java.util.Arrays;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 23.09.18.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля BidPercent в медийной кампании")
@Issue("https://st.yandex-team.ru/DIRECT-84939")
@RunWith(Parameterized.class)
public class HolidayScheduleBidPercentValidationTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Parameterized.Parameter(0)
    public Integer bidPercent;

    @Parameterized.Parameter(1)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "BidPercent = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
//                {TimeTargetingOnPublicHolidaysMap.DEFAULT_BID_PERCENT, ExpectedResult.success()},
                {TimeTargetingOnPublicHolidaysMap.MIN_BID_PERCENT - 10,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(
                                        new Notification(4000,
                                                Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER),
                                        new Notification(4000,
                                                Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER)
                                ))
                                .perl(ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000,
                                        Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER)))},

                {TimeTargetingOnPublicHolidaysMap.MAX_BID_PERCENT + 10,
                        JavaOrPerlExpectedResult.java(
                                ExpectedResult.errorsIgnoringDetails(
                                        new Notification(4000,
                                                Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER),
                                        new Notification(4000,
                                                Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER)
                                ))
                                .perl(ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000, Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER)
                        ))},

                {null, JavaOrPerlExpectedResult.both(ExpectedResult.success())},

                {TimeTargetingOnPublicHolidaysMap.DEFAULT_BID_PERCENT - 10,
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                        Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER)))},

                {TimeTargetingOnPublicHolidaysMap.DEFAULT_BID_PERCENT + 10,
                        JavaOrPerlExpectedResult.both(ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER)))},

                {55, JavaOrPerlExpectedResult.java(ExpectedResult.errorsIgnoringDetails(
                        new Notification(4000, Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER),
                        new Notification(4000, Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER)))
                        .perl(ExpectedResult.errorsIgnoringDetails(
                        new Notification(4000, Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER)))},
        });
    }

    @Test
    public void requestWithBidPercent() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTimeTargeting(new TimeTargetingAddMap()
                                .withConsiderWorkingWeekends(YesNoEnum.NO)
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                        .withSuspendOnHolidays(YesNoEnum.NO)
                                        .withStartHour(10)
                                        .withEndHour(20)
                                        .withBidPercent(bidPercent)))
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .defaultCpmBannerCampaign())),
                expectedResult);
    }
}
