package ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbDecreasedPriceForRepeatedImpressionsAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbMaximumImpressionsAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Создание кампании при несоответствии имени стратегии и набора переданных параметров стратегии")
public class StrategyNameMismatchParamsTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public CpmBannerCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public CpmBannerCampaignNetworkStrategyAddMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Network: несоответствие имени и параметров",
                        new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff(),
                        new CpmBannerCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS)
                                .withWbMaximumImpressions(new StrategyWbMaximumImpressionsAddMap()
                                .withAverageCpm(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withSpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.NETWORK_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                {"Network: стратегия не требующая параметров",
                        new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff(),
                        new CpmBannerCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM)
                                .withWbMaximumImpressions(new StrategyWbMaximumImpressionsAddMap()
                                .withAverageCpm(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withSpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.NETWORK_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                {"Network: стратегия без необходимых парметров",
                        new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff(),
                        new CpmBannerCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS),
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000, Api5ErrorDetails.STRATEGY_ON_NETWORK_MUST_CONTAINS_SETTINGS,
                                        CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS))},
                {"Network: лишние параметры стратегий",
                        new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff(),
                        new CpmBannerCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS)
                                .withWbMaximumImpressions(new StrategyWbMaximumImpressionsAddMap()
                                .withAverageCpm(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withSpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue()))
                                .withWbDecreasedPriceForRepeatedImpressions(new StrategyWbDecreasedPriceForRepeatedImpressionsAddMap()
                                .withAverageCpm(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withSpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000, Api5ErrorDetails.MULTIPLE_NETWORK_STRATEGY_PARAMS))}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void nameMismatchParamsTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                expectedResult);
    }
}