package ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.strategy.cp;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpDecreasedPriceForRepeatedImpressionsAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpMaximumImpressionsAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpMaximumImpressionsMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap.DATE_PATTERN;

/**
 * Created by gerdler on 16.09.2018.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра EndDate при добавлении кампании со стратегиями с произвольным периодом")
public class StrategiesCustomPeriodEndDateNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    private static final long averageCpm = moneyCurrency.getMinCpmPrice().bidLong().longValue();

    // *3 - это продолжительность кампании в днях, DAY_AFTER_END_DATE - START_DATE
    // https://a.yandex-team.ru/arc_vcs/direct/core/src/main/java/ru/yandex/direct/core/entity/campaign/service/CampaignStrategyUtils.java?rev=r8841484#L100
    private static final long spendLimit = moneyCurrency.getMinDailyBudgetForPeriod().bidLong().longValue() * 3;

    private static final String START_DATE = DateTime.now().plusDays(1).toString(DATE_PATTERN);
    private static final String END_DATE = DateTime.now().plusDays(2).toString(DATE_PATTERN);
    private static final String DAY_AFTER_END_DATE = DateTime.now().plusDays(3).toString(DATE_PATTERN);
    private static final String YESTERDAY = DateTime.now().minusDays(1).toString(DATE_PATTERN);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String startDate;

    @Parameterized.Parameter(value = 2)
    public String endDate;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {
                        "Строка",
                        START_DATE,
                        "строка",
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000, Api5ErrorDetails.DATE_INVALID_FORMAT_IN_FILED,
                                        capitalize(StrategyCpMaximumImpressionsMap.END_DATE))
                        )
                },
                {
                        "Нулевое значение",
                        START_DATE,
                        "0000-00-00",
                        ExpectedResult.errorsIgnoringDetails(
                            new Notification(4000, Api5ErrorDetails.DATE_INVALID_FORMAT_IN_FILED,
                                    capitalize(StrategyCpMaximumImpressionsMap.END_DATE))
                        )
                },
                {
                        "Некорректная дата",
                        START_DATE,
                        "2018-02-30",
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000, Api5ErrorDetails.DATE_INVALID_FORMAT_IN_FILED,
                                        capitalize(StrategyCpMaximumImpressionsMap.END_DATE))
                        )
                },
                {
                        "Дата со временем",
                        START_DATE,
                        END_DATE + " 10:00:00",
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000, Api5ErrorDetails.DATE_INVALID_FORMAT_IN_FILED,
                                        capitalize(StrategyCpMaximumImpressionsMap.END_DATE))
                        )
                },
                {
                        "Дата окончания стратегии в прошлом",
                        YESTERDAY,
                        YESTERDAY,
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000, Api5ErrorDetails.CP_DATE_CANT_BE_EARLY_THAN_TODAY,
                                        capitalize(StrategyCpMaximumImpressionsMap.END_DATE))
                        )
                },
                {
                        "Дата окончания стратегии больше даты окончания кампании",
                        START_DATE,
                        DAY_AFTER_END_DATE,
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000, Api5ErrorDetails.CP_END_DATE_CANT_BE_LATER_END_DATE)
                        )
                },
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void cpMaximumImpressionsEndDateNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                            CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                                                        )
                                                .withCpMaximumImpressions(
                                                        new StrategyCpMaximumImpressionsAddMap()
                                                                .withStartDate(startDate)
                                                                .withEndDate(endDate)
                                                                .withAverageCpm(averageCpm)
                                                                .withSpendLimit(spendLimit)
                                                                .withAutoContinue(YesNoEnum.YES)
                                                )

                                        )))),
                expectedResult);
    }

    @Test
    public void cpDecreasedPriceForRepeatedImpressionsEndDateNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS
                                                        )
                                                        .withCpDecreasedPriceForRepeatedImpressions(
                                                                new StrategyCpDecreasedPriceForRepeatedImpressionsAddMap()
                                                                        .withStartDate(startDate)
                                                                        .withEndDate(endDate)
                                                                        .withAverageCpm(averageCpm)
                                                                        .withSpendLimit(spendLimit)
                                                                        .withAutoContinue(YesNoEnum.YES)
                                                        )

                                        )))),
                expectedResult);
    }
}
