package ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.strategy.cp;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpDecreasedPriceForRepeatedImpressionsAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpMaximumImpressionsAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap.DATE_PATTERN;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Негативные сценарии проверки параметра AutoContinue при добавлении кампании со стратегиями с произвольным периодом")
public class StrategiesCustomPeriodRequiredFieldTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Currency CURRENCY = Currency.RUB;
    private static final MoneyCurrency MONEY_CURRENCY = MoneyCurrency.get(CURRENCY);

    private static final long AVERAGE_CPM = MONEY_CURRENCY.getMinCpmPrice().bidLong().longValue();
    private static final long SPEND_LIMIT = MONEY_CURRENCY.getMinDailyBudgetForPeriod().bidLong().longValue();

    private static final String START_DATE = DateTime.now().plusDays(1).toString(DATE_PATTERN);
    private static final String END_DATE = START_DATE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    public void cpMaximumImpressionsAutoContinueMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                                                        )
                                                        .withCpMaximumImpressions(
                                                                new StrategyCpMaximumImpressionsAddMap()
                                                                        .withStartDate(START_DATE)
                                                                        .withEndDate(END_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                        )

                                        )))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_MAXIMUM_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.AUTO_CONTINUE)));
    }

    @Test
    public void cpDecreasedPriceForRepeatedImpressionsAutoContinueMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS
                                                        )
                                                        .withCpDecreasedPriceForRepeatedImpressions(
                                                                new StrategyCpDecreasedPriceForRepeatedImpressionsAddMap()
                                                                        .withStartDate(START_DATE)
                                                                        .withEndDate(END_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                        )

                                        )))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.AUTO_CONTINUE)));
    }

    @Test
    public void cpMaximumImpressionsStartDateMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                                                        )
                                                        .withCpMaximumImpressions(
                                                                new StrategyCpMaximumImpressionsAddMap()
                                                                        .withEndDate(END_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                                        .withAutoContinue(YesNoEnum.YES)
                                                        )

                                        )))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_MAXIMUM_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.START_DATE)));
    }

    @Test
    public void cpDecreasedPriceForRepeatedImpressionsStartDateMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS
                                                        )
                                                        .withCpDecreasedPriceForRepeatedImpressions(
                                                                new StrategyCpDecreasedPriceForRepeatedImpressionsAddMap()
                                                                        .withEndDate(END_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                                        .withAutoContinue(YesNoEnum.YES)
                                                        )

                                        )))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.START_DATE)));
    }

    @Test
    public void cpMaximumImpressionsEndDateMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                                                        )
                                                        .withCpMaximumImpressions(
                                                                new StrategyCpMaximumImpressionsAddMap()
                                                                        .withStartDate(START_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                                        .withAutoContinue(YesNoEnum.YES)
                                                        )

                                        )))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_MAXIMUM_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.END_DATE)));
    }

    @Test
    public void cpDecreasedPriceForRepeatedImpressionsEndDateMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS
                                                        )
                                                        .withCpDecreasedPriceForRepeatedImpressions(
                                                                new StrategyCpDecreasedPriceForRepeatedImpressionsAddMap()
                                                                        .withStartDate(START_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                                        .withAutoContinue(YesNoEnum.YES)
                                                        )

                                        )))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.END_DATE)));
    }
}
