package ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.strategy.cp;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpDecreasedPriceForRepeatedImpressionsAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpMaximumImpressionsAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 16.09.2018.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра SpendLimit при добавлении кампании со стратегиями на фиксированный период")
public class StrategiesCustomPeriodSpendLimitTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    private static final long averageCpm = moneyCurrency.getMinCpmPrice().bidLong().longValue();
    private static final Money minLimit = moneyCurrency.getMinDailyBudgetForPeriod();
    private static final Money maxLimit = moneyCurrency.getMaxDailyBudgetForPeriod();

    private static final String START_DATE = DateTime.now().plusDays(1).toString(CampaignAddItemMap.DATE_PATTERN);
    private static final String END_DATE = START_DATE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long spendLimit;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {
                        "Нулевое значение",
                        0L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.FIXED_PERIOD_BUDGET_CANNOT_BE_LESS,
                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))
                },
                {
                        "Отрицательное значение",
                        -1L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.FIXED_PERIOD_BUDGET_CANNOT_BE_LESS,
                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))
                },
                {
                        "Значение меньше минимального",
                        minLimit.getPrevious().bidLong().longValue(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.FIXED_PERIOD_BUDGET_CANNOT_BE_LESS,
                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))
                },
                {
                        "Значение больше максимального",
                        maxLimit.getNext().bidLong().longValue(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.FIXED_PERIOD_BUDGET_CANNOT_BE_MORE,
                                maxLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))
                },
                {
                        "Значение равное минимальному",
                        minLimit.bidLong().longValue(),
                        ExpectedResult.success()
                },
                {
                        "Значение равное максимальному",
                        maxLimit.bidLong().longValue(),
                        ExpectedResult.success()
                },
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void cpMaximumImpressionsSpendLimitNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                            CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                                                        )
                                                .withCpMaximumImpressions(
                                                        new StrategyCpMaximumImpressionsAddMap()
                                                                .withStartDate(START_DATE)
                                                                .withEndDate(END_DATE)
                                                                .withAverageCpm(averageCpm)
                                                                .withSpendLimit(spendLimit)
                                                                .withAutoContinue(YesNoEnum.YES)
                                                )

                                        )))),
                expectedResult);
    }

    @Test
    public void cpDecreasedPriceForRepeatedImpressionsSpendLimitNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS
                                                        )
                                                        .withCpDecreasedPriceForRepeatedImpressions(
                                                                new StrategyCpDecreasedPriceForRepeatedImpressionsAddMap()
                                                                        .withStartDate(START_DATE)
                                                                        .withEndDate(END_DATE)
                                                                        .withAverageCpm(averageCpm)
                                                                        .withSpendLimit(spendLimit)
                                                                        .withAutoContinue(YesNoEnum.YES)
                                                        )

                                        )))),
                expectedResult);
    }
}
