package ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.strategy.cpv;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpAverageCpvAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbAverageCpvAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap.DATE_PATTERN;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Сценарии проверки параметра AverageCpv при добавлении кампаний")
public class StrategiesAverageCpvTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Currency CURRENCY = Currency.RUB;
    private static final MoneyCurrency MONEY_CURRENCY = MoneyCurrency.get(CURRENCY);

    private static final Money MIN_PRICE = MONEY_CURRENCY.getMinAvgCpv();

    private static final String START_DATE = DateTime.now().plusDays(1).toString(DATE_PATTERN);
    private static final String END_DATE = START_DATE;

    private static final Long SPEND_LIMIT = MONEY_CURRENCY.getMaxDailyBudgetForPeriod().bidLong().longValue();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long averageCpv;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {
                        "Нулевое значение",
                        0L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.AVERAGE_CPV_SHOULD_BE_MORE_THAN,
                                MIN_PRICE.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                MONEY_CURRENCY.getApiDescription()))
                },
                {
                        "Отрицательное значение",
                        -1L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.AVERAGE_CPV_SHOULD_BE_MORE_THAN,
                                MIN_PRICE.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                MONEY_CURRENCY.getApiDescription()))
                },
                {
                        "Значение меньше минимального",
                        MIN_PRICE.getPrevious().bidLong().longValue(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.AVERAGE_CPV_SHOULD_BE_MORE_THAN,
                                MIN_PRICE.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                MONEY_CURRENCY.getApiDescription()))
                },
                {
                        "Значение равное минимальному",
                        MIN_PRICE.bidLong().longValue(),
                        ExpectedResult.success()
                },
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        Long clientId = Long.parseLong(User.get(CLIENT).getClientID());
        dbSteps.featuresSteps().ensureClientHasFeatureIfNotSet(clientId, "cpv_strategies_enabled");
    }

    @Test
    public void cpAverageCpvTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_AVERAGE_CPV
                                                        )
                                                        .withCpAverageCpv(
                                                                new StrategyCpAverageCpvAddMap()
                                                                        .withStartDate(START_DATE)
                                                                        .withEndDate(END_DATE)
                                                                        .withAverageCpv(averageCpv)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                                        .withAutoContinue(YesNoEnum.YES))

                                        )))),
                expectedResult);
    }

    @Test
    public void wbAverageCpvTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.WB_AVERAGE_CPV
                                                        )
                                                        .withWbAverageCpv(
                                                                new StrategyWbAverageCpvAddMap()
                                                                        .withAverageCpv(averageCpv)
                                                                        .withSpendLimit(SPEND_LIMIT))

                                        )))),
                expectedResult);
    }

}
