package ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.strategy.cpv;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbAverageCpvAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbAverageCpvMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Позитивные сценарии проверки создании кампании со стратегией wbAverageCpv")
@Tag(TagDictionary.TRUNK)
public class StrategyAverageCpvPositiveTest {
    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Currency CURRENCY = Currency.RUB;
    private static final MoneyCurrency MONEY_CURRENCY = MoneyCurrency.get(CURRENCY);
    private static final Long SPEND_LIMIT = MONEY_CURRENCY.getMaxDailyBudgetForPeriod().bidLong().longValue();

    private static final Money MIN_AVG_CPV = MoneyCurrency.get(CURRENCY).getMinAvgCpv();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    private CpmBannerCampaignStrategyMap expectedStrategyMap;

    @Before
    @Step("Подготовим данные для теста")
    public void setUp() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);

        //проверяем фичу
        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        Long clientId = Long.parseLong(User.get(CLIENT).getClientID());
        dbSteps.featuresSteps().ensureClientHasFeatureIfNotSet(clientId, "cpv_strategies_enabled");

        expectedStrategyMap = new CpmBannerCampaignStrategyMap()
                .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                .withNetwork(
                        new CpmBannerCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(
                                        CpmBannerCampaignNetworkStrategyTypeEnum.WB_AVERAGE_CPV
                                )
                                .withWbAverageCpv(
                                        new StrategyWbAverageCpvMap()
                                                .withAverageCpv(MIN_AVG_CPV.getNext().bidLong().longValue())
                                                .withSpendLimit(SPEND_LIMIT))

                );
    }

    @Test
    public void wbAverageCpvPositiveTest() {
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.WB_AVERAGE_CPV
                                                        )
                                                        .withWbAverageCpv(
                                                                new StrategyWbAverageCpvAddMap()
                                                                        .withAverageCpv(MIN_AVG_CPV.getNext().bidLong().longValue())
                                                                        .withSpendLimit(SPEND_LIMIT))

                                        )))),
                ExpectedResult.success());

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(response.getAddResults().get(0).getId()))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withCpmBannerCampaignFieldNames(CpmBannerCampaignFieldEnum.BIDDING_STRATEGY));


        assumeThat("получили результаты обновления кампании", response.getAddResults(), hasSize(1));

        assumeThat("получили кампанию", campaigns, hasSize(1));
        CpmBannerCampaignStrategy actualStrategy = campaigns.get(0).getCpmBannerCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((CpmBannerCampaignStrategy) expectedStrategyMap.getBean()));
    }

}
