package ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.strategy.wb;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbDecreasedPriceForRepeatedImpressionsAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbMaximumImpressionsAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 16.09.2018.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Сценарии проверки параметра SpendLimit при добавлении кампаний")
public class StrategiesWeeklySpendLimitTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Currency CURRENCY = Currency.RUB;
    private static final MoneyCurrency MONEY_CURRENCY = MoneyCurrency.get(CURRENCY);

    private static final long AVERAGE_CPM = MONEY_CURRENCY.getMinCpmPrice().bidLong().longValue();
    private static final Money MIN_LIMIT = MONEY_CURRENCY.getMinDailyBudgetForPeriod().multiply(7);
    private static final Money MAX_LIMIT = MONEY_CURRENCY.getMaxWeeklyBudgetAmount();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long spendLimit;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {
                        "Нулевое значение",
                        0L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                MIN_LIMIT.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                MONEY_CURRENCY.getApiDescription()))},
                {
                        "Отрицательное значение",
                        -1L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                MIN_LIMIT.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                MONEY_CURRENCY.getApiDescription()))},
                {
                        "Значение меньше минимального",
                        MIN_LIMIT.getPrevious().bidLong().longValue(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                MIN_LIMIT.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                MONEY_CURRENCY.getApiDescription()))},
                {
                        "Значение больше максимального",
                        MAX_LIMIT.getNext().bidLong().longValue(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.WEEKLY_LIMIT_IS_TOO_HIGH,
                                MAX_LIMIT.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                MONEY_CURRENCY.getApiDescription()))},
                {
                        "Значение равное минимальному",
                        MIN_LIMIT.bidLong().longValue(),
                        ExpectedResult.success()},
                {
                        "Значение равное максимальному",
                        MAX_LIMIT.bidLong().longValue(),
                        ExpectedResult.success()},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void wbMaximumImpressionsTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS
                                                        )
                                                        .withWbMaximumImpressions(
                                                                new StrategyWbMaximumImpressionsAddMap()
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(spendLimit))

                                        )))),
                expectedResult);
    }

    @Test
    public void wbDecreasedPriceForRepeatedImpressionsTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.WB_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS
                                                        )
                                                        .withWbDecreasedPriceForRepeatedImpressions(
                                                                new StrategyWbDecreasedPriceForRepeatedImpressionsAddMap()
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(spendLimit))

                                        )))),
                expectedResult);
    }
}
