package ru.yandex.autotests.direct.api.campaigns.add.dailybudget;

import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.common.SpendMode;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountDayBudgetInfoMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static java.util.Arrays.asList;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.success;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.warningsIgnoringDetailsAndMessage;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка предупреждений на поле DailyBudget.amount с учетом дневного бюджета на общем счёте")
@Issue("https://st.yandex-team.ru/DIRECT-64426")
@RunWith(Parameterized.class)
public class AddCampaignAccountDailyBudgetAmountWarningTest {
    private static final Float DISABLED_ACCOUNT_DAILY_BUDGET_AMOUNT = 0F;
    private static final Float ENABLED_ACCOUNT_DAILY_BUDGET_AMOUNT = 1000F;

    private static final String LOGIN = CampaignsLogins.CAMPAIGNS_ACCOUNT_DAILY_BUDGET_LOGIN1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN, LOGIN);

    private static int accountId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public Float accountBudgetAmount;

    @Parameterized.Parameter(1)
    public Long campaignBudgetAmount;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "account budget = {0}, campaign budget = {1}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][]{
                // дневной бюджет на ОС выключен
                new Object[]{DISABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, 500000000L, success()},

                // дневной бюджет на ОС включен
                new Object[]{ENABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, 500000000L, success()},
                new Object[]{ENABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, 1000000000L, success()},
                new Object[]{ENABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, 2000000000L,
                        warningsIgnoringDetailsAndMessage(new Notification(10030, Api5ErrorDetails.NO_EFFECT_WALLET_DAY_BUDGET))}
        };

        return asList(result);
    }

    @BeforeClass
    public static void setUp() {
        accountId = api.userSteps.financeSteps().getAccountID(LOGIN);
    }

    @Before
    public void tuneAccountDailyBudget() {
        api.userSteps.campaignFakeSteps().setDayBudgetChangeCount(accountId, 0);
        api.userSteps.financeSteps().update(new AccountMap(api.type())
                .withAccountID(accountId)
                .withAccountDayBudget(new AccountDayBudgetInfoMap(api.type())
                        .withAmount(accountBudgetAmount)
                        .withSpendMode(SpendMode.DEFAULT.getValue())));
    }

    @Test
    public void test() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .withDefaultCampaign(CampaignType.TEXT)
                                .defaultCampaignAddItem()
                                .withDailyBudget(new DailyBudgetMap()
                                        .withAmount(campaignBudgetAmount)
                                        .withMode(DailyBudgetModeEnum.STANDARD))),
                expectedResult);
    }
}
