package ru.yandex.autotests.direct.api.campaigns.add.dailybudget;

import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.common.SpendMode;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountDayBudgetInfoMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static java.util.Arrays.asList;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.success;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.warnings;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.warningsIgnoringDetails;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка предупреждений на поле DailyBudget.mode с учетом дневного бюджета на общем счёте")
@Issue("https://st.yandex-team.ru/DIRECT-64426")
@RunWith(Parameterized.class)
public class AddCampaignAccountDailyBudgetModeWarningTest {
    private static final Float DISABLED_ACCOUNT_DAILY_BUDGET_AMOUNT = 0F;
    private static final Float ENABLED_ACCOUNT_DAILY_BUDGET_AMOUNT = 1000F;
    private static final Long CAMPAIGN_DAILY_BUDGET_AMOUNT =
            ENABLED_ACCOUNT_DAILY_BUDGET_AMOUNT.longValue() * 1_000_000;

    private static final String LOGIN = CampaignsLogins.CAMPAIGNS_ACCOUNT_DAILY_BUDGET_LOGIN2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN, LOGIN);

    private static int accountId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public Float accountBudgetAmount;

    @Parameterized.Parameter(1)
    public SpendMode accountMode;

    @Parameterized.Parameter(2)
    public DailyBudgetModeEnum campaignMode;

    @Parameterized.Parameter(3)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "account budget = {0}, account mode = {1}, campaign mode = {2}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][]{
                // дневной бюджет на ОС выключен
                new Object[]{DISABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, SpendMode.DEFAULT, DailyBudgetModeEnum.STANDARD,
                        JavaOrPerlExpectedResult.both(success())},
                new Object[]{DISABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, SpendMode.DEFAULT, DailyBudgetModeEnum.DISTRIBUTED,
                        JavaOrPerlExpectedResult.both(success())},
                new Object[]{DISABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, SpendMode.STRETCHED, DailyBudgetModeEnum.STANDARD,
                        JavaOrPerlExpectedResult.both(success())},
                new Object[]{DISABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, SpendMode.STRETCHED, DailyBudgetModeEnum.DISTRIBUTED,
                        JavaOrPerlExpectedResult.both(success())},

                // дневной бюджет на ОС включен
                new Object[]{ENABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, SpendMode.DEFAULT, DailyBudgetModeEnum.STANDARD,
                        JavaOrPerlExpectedResult
                                .java(success())
                                .perl(success())},
                new Object[]{ENABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, SpendMode.DEFAULT, DailyBudgetModeEnum.DISTRIBUTED,
                        JavaOrPerlExpectedResult
                                .both(warnings(new Notification(10030,
                                        Api5ErrorDetails.NO_EFFECT_WALLET_DAY_BUDGET_SHOW_MODE)))},
                new Object[]{ENABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, SpendMode.STRETCHED, DailyBudgetModeEnum.STANDARD,
                        JavaOrPerlExpectedResult
                                .both(warningsIgnoringDetails(new Notification(10030,
                                        Api5ErrorDetails.NO_EFFECT_WALLET_DAY_BUDGET_SHOW_MODE)))},
                new Object[]{ENABLED_ACCOUNT_DAILY_BUDGET_AMOUNT, SpendMode.STRETCHED, DailyBudgetModeEnum.DISTRIBUTED,
                        JavaOrPerlExpectedResult
                                .java(success())
                                .perl(success())},
        };

        return asList(result);
    }

    @BeforeClass
    public static void setUp() {
        accountId = api.userSteps.financeSteps().getAccountID(LOGIN);
    }

    @Before
    public void tuneAccountDailyBudget() {
        // accountId - это walletCid, поэтому это норм передавать его в функцию setDayBudgetChangeCount
        api.userSteps.campaignFakeSteps().setDayBudgetChangeCount(accountId, 0);
        api.userSteps.financeSteps().update(new AccountMap(api.type())
                .withAccountID(accountId)
                .withAccountDayBudget(new AccountDayBudgetInfoMap(api.type())
                        .withAmount(accountBudgetAmount)
                        .withSpendMode(accountMode.getValue())));
    }

    @Test
    public void test() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .withDefaultCampaign(CampaignType.TEXT)
                                .defaultCampaignAddItem()
                                .withDailyBudget(new DailyBudgetMap()
                                        .withAmount(CAMPAIGN_DAILY_BUDGET_AMOUNT)
                                        .withMode(campaignMode))),
                expectedResult);
    }
}
