package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsArrayMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации PriorityGoals")
@Issue("https://st.yandex-team.ru/DIRECT-98633")
@RunWith(Parameterized.class)
public class PriorityGoalsNegativeTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Integer COUNTER_ID = 32265784;
    private static final Long GOAL_ID = 13088934L;
    // цель CampaignsLogins.UPDATE_CLIENT, недоступная CLIENT
    private static final Integer ALIEN_COUNTER_ID = 34981090;
    private static final Long ALIEN_GOAL_ID = 17108070L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public DynamicTextCampaignAddItemMap dynamicTextCampaign;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"zero goal id",
                        new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .defaultDynamicTextCampaignStrategy())
                                .withPriorityGoals(new PriorityGoalsArrayMap()
                                        .withItems(new PriorityGoalsItemMap()
                                                .withGoalId(0L)
                                                .withValue(10000000L))),
                        ExpectedResult.errorsIgnoringDetails(new Notification(8800,
                                Api5ErrorDetails.PRIORITY_GOAL_ID_NOT_FOUND,
                                0L))
                },
                {"invalid goal id",
                        new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .defaultDynamicTextCampaignStrategy())
                                .withCounterIds(COUNTER_ID)
                                .withPriorityGoals(new PriorityGoalsArrayMap()
                                        .withItems(new PriorityGoalsItemMap()
                                                .withGoalId(999L)
                                                .withValue(10000000L))),
                        ExpectedResult.errorsIgnoringDetails(new Notification(8800,
                                Api5ErrorDetails.PRIORITY_GOAL_ID_NOT_FOUND,
                                999L))
                },
                {"valid goal_id without counter",
                        new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .defaultDynamicTextCampaignStrategy())
                                .withPriorityGoals(new PriorityGoalsArrayMap()
                                        .withItems(new PriorityGoalsItemMap()
                                                .withGoalId(GOAL_ID)
                                                .withValue(10000000L))),
                        ExpectedResult.errorsIgnoringDetails(new Notification(8800,
                                Api5ErrorDetails.PRIORITY_GOAL_ID_NOT_FOUND,
                                GOAL_ID))
                },
                {"inaccessible valid goal id",
                        new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .defaultDynamicTextCampaignStrategy())
                                .withCounterIds(ALIEN_COUNTER_ID)
                                .withPriorityGoals(new PriorityGoalsArrayMap()
                                        .withItems(new PriorityGoalsItemMap()
                                                .withGoalId(ALIEN_GOAL_ID)
                                                .withValue(10000000L))),
                        ExpectedResult.errorsIgnoringDetails(new Notification(8800,
                                Api5ErrorDetails.PRIORITY_GOAL_ID_NOT_FOUND,
                                ALIEN_GOAL_ID))
                },
                {"too small value",
                        new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .defaultDynamicTextCampaignStrategy())
                                .withPriorityGoals(new PriorityGoalsArrayMap()
                                        .withItems(new PriorityGoalsItemMap()
                                                .withEngagedSessionGoalId()
                                                .withValue(0L))),
                        ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                                Api5ErrorDetails.PRIORITY_GOAL_VALUE_TOO_SMALL,
                                PriorityGoalsItemMap.ENGAGED_SESSION_GOAL_ID,
                                "0.30", Currency.RUB.value().toLowerCase()))
                },
                {"too big value",
                        new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .defaultDynamicTextCampaignStrategy())
                                .withPriorityGoals(new PriorityGoalsArrayMap()
                                        .withItems(new PriorityGoalsItemMap()
                                                .withEngagedSessionGoalId()
                                                .withValue(4_000_000_000_000_000_000L))),
                        ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                                Api5ErrorDetails.PRIORITY_GOAL_VALUE_TOO_BIG,
                                PriorityGoalsItemMap.ENGAGED_SESSION_GOAL_ID,
                                "300 000 000.00", Currency.RUB.value().toLowerCase()))
                },
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        Long clientId = Long.parseLong(User.get(CLIENT).getClientID());
        dbSteps.featuresSteps().setClientFeature(clientId, "direct_unavailable_goals_allowed", false);
    }

    @Test
    public void addWithInvalidPriorityGoals() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDynamicTextCampaign(dynamicTextCampaign)
                        ),
                expectedResult);
    }
}
