package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.settings;

import java.util.Arrays;
import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbehavior;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка не поддерживаемых значений поля Settings в мобильных кампаниях")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
@ParametersAreNonnullByDefault
public class AddDeprecatedSettingsTest {
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static String client = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public DynamicTextCampaignSettingsEnum option;

    @Parameterized.Parameter(1)
    public YesNoEnum settingValue;

    @Parameterized.Parameters(name = "option = {0}, value = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                // DIRECT-69528
                {DynamicTextCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING, YesNoEnum.NO},
                {DynamicTextCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING, YesNoEnum.YES}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("146")
    public void checkSettingsTest() {
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(
                        new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                        .defaultDynamicTextCampaign()
                                        .withSettings(new DynamicTextCampaignSettingMap()
                                                .withOption(option)
                                                .withValue(settingValue)))),
                ExpectedResult.warningsIgnoringDetailsAndMessage(
                        new Notification(10163, Api5ErrorDetails.CAMPAIGN_SETTING_DEPRECATED, option)));

        Long campaignID = response.getAddResults().get(0).getId();

        CampaignsStatusbehavior statusBehavior =
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campaignsSteps()
                        .getCampaignById(campaignID).getStatusbehavior();
        assertThat("кампания создалась с правильным значением настройки", statusBehavior,
                equalTo(CampaignsStatusbehavior.Yes));
    }
}
