package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 19.11.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Позитивные сценарии создания мобильной кампании с автостратегиями для Search и комбинациями стратегий для Network")
@Tag(TagDictionary.TRUNK)
public class StrategyCombinationsAutoSearchTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String searchName;

    @Parameterized.Parameter(value = 1)
    public String conDynamicTextName;

    @Parameterized.Parameter(value = 2)
    public DynamicTextCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameter(value = 3)
    public DynamicTextCampaignNetworkStrategyAddMap networkStrategy;

    @Parameterized.Parameter(value = 4)
    public DynamicTextCampaignSearchStrategyMap expectedSearchStrategy;

    @Parameterized.Parameter(value = 5)
    public DynamicTextCampaignNetworkStrategyMap expectedNetworkStrategy;

    @Parameterized.Parameters(name = "search = {0}, network = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-45818
                //ServingOff для Network
                {"AverageCpc", "ServingOff",
                        new DynamicTextCampaignSearchStrategyAddMap().defaultAverageCpc(currency),
                        new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpc(currency),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff()},
                {"MaximumClicks", "ServingOff",
                        new DynamicTextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(currency),
                        new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumClicks(currency),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff()},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("130")
    public void strategyNetworkTest() {
        List<Long> ids = api.userSteps.campaignSteps().campaignsAddWithCheck(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                .withSearch(searchStrategy)
                                .withNetwork(networkStrategy))));
        assumeThat("создана кампания", ids, hasSize(1));


        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(ids.get(0)))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        DynamicTextCampaignStrategy actualStrategy = campaigns.get(0).getDynamicTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        DynamicTextCampaignStrategyMap expectedStrategy = new DynamicTextCampaignStrategyMap()
                .withSearch(expectedSearchStrategy)
                .withNetwork(expectedNetworkStrategy);

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((DynamicTextCampaignStrategy) expectedStrategy.getBean()));
    }
}
