package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.averagecrr;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCrrAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCrrMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Сценарии проверки создания кампании со стратегией AverageCrr")
public class StrategyAverageCrrPositiveTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Integer COUNTER_ID = MetrikaGoals.getCounterForLogin(client);
    private static final Money MIN_LIMIT = MoneyCurrency.get(Currency.RUB).getMinWeeklyBudgetAmount();
    private static final Money MAX_LIMIT = MoneyCurrency.get(Currency.RUB).getMaxWeeklyBudgetAmount();

    private DynamicTextCampaignStrategyAddMap strategyMap;
    private DynamicTextCampaignStrategyMap expectedStrategyMap;
    
    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long goalId;

    @Parameterized.Parameter(value = 2)
    public Integer crr;

    @Parameterized.Parameter(value = 3)
    public Long weeklySpendLimit;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {
                        "Создание новой кампании",
                        MetrikaGoals.getGoalForCounter(COUNTER_ID),
                        StrategyAverageCrrAddMap.DEFAULT_CRR,
                        StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT,
                },
                {
                        "Создание новой кампании с минимальным ДРР",
                        MetrikaGoals.getGoalForCounter(COUNTER_ID),
                        StrategyAverageCrrAddMap.MIN_CRR,
                        StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT,
                },
                {
                        "Создание новой кампании с максимальным ДРР",
                        MetrikaGoals.getGoalForCounter(COUNTER_ID),
                        StrategyAverageCrrAddMap.MAX_CRR,
                        StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT,
                },
                {
                        "Создание новой кампании с минимальным бюджетом",
                        MetrikaGoals.getGoalForCounter(COUNTER_ID),
                        StrategyAverageCrrAddMap.DEFAULT_CRR,
                        MIN_LIMIT.bidLong().longValue(),
                },
                {
                        "Создание новой кампании с максимальным бюджетм",
                        MetrikaGoals.getGoalForCounter(COUNTER_ID),
                        StrategyAverageCrrAddMap.DEFAULT_CRR,
                        MAX_LIMIT.bidLong().longValue(),
                },
                {
                        "Создание новой кампании без недельного бюджета",
                        MetrikaGoals.getGoalForCounter(COUNTER_ID),
                        StrategyAverageCrrAddMap.DEFAULT_CRR,
                        null
                }
        };
        return Arrays.asList(data);
    }

    @Before
    public void clearUnits() {
        strategyMap = new DynamicTextCampaignStrategyAddMap()
                .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CRR)
                        .withAverageCrr(new StrategyAverageCrrAddMap()
                                .withCrr(crr)
                                .withWeeklySpendLimit(weeklySpendLimit)
                                .withGoalId(goalId)
                        )
                ).withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff());
        
        expectedStrategyMap = new DynamicTextCampaignStrategyMap()
                .withSearch(new DynamicTextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CRR)
                        .withAverageCrr(new StrategyAverageCrrMap()
                                .withGoalId(goalId)
                                .withCrr(crr)
                                .withWeeklySpendLimit(weeklySpendLimit)
                        )
                ).withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff());
    }
    
    @Test
    public void shouldCreateCampaign() {
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withCounterIds(COUNTER_ID)
                                .withBiddingStrategy(strategyMap)
                        )
                ),
                ExpectedResult.success()
        );

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(response.getAddResults().get(0).getId())
                )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.BIDDING_STRATEGY)
        );

        assumeThat("получили кампанию", campaigns, hasSize(1));

        assertThat("получили корректные стратегии",
                campaigns.get(0).getDynamicTextCampaign().getBiddingStrategy(),
                beanDifferV5(expectedStrategyMap.getBean())
        );
    }
}