package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.averageroi;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsArrayMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiAddMap.MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID;

/**
 * Created by pashkus on 28.09.2019.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра GoalId при обновлении кампании со стратегией AverageRoi")
@Tag(TagDictionary.TRUNK)
public class StrategyAverageRoiMeaningfulGoalIdNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;

    private DynamicTextCampaignStrategyAddMap strategyMap;
    private static final Long TEST_MEANINGFUL_GOAL_VALUE = 13_000_000L;
    private static final Integer COUNTER_ID = MetrikaGoals.getCounterForLogin(client);

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public PriorityGoalsArrayMap prioiityGoals;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection priorityGoals() {
        Object[][] data = new Object[][]{
                {"КЦ не заданы", null,
                        ExpectedResult.errors(new Notification(4000, Api5ErrorDetails.ROI_MEANINGFUL_GOALS_IS_NOT_SET))},
                {"КЦ вовлеченные сессии", new PriorityGoalsArrayMap().withItems(
                        new PriorityGoalsItemMap()
                                .withEngagedSessionGoalId()
                                .withValue(TEST_MEANINGFUL_GOAL_VALUE)),
                        ExpectedResult.errors(new Notification(4000, Api5ErrorDetails.ROI_MEANINGFUL_GOALS_IS_NOT_SET))},
        };
        return Arrays.asList(data);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        strategyMap = new DynamicTextCampaignStrategyAddMap()
                .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                        .withAverageRoi(new StrategyAverageRoiAddMap()
                                .defaultStrategyAverageRoi()
                                .withGoalId(MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID)))
                .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff());
    }

    @Test
    public void goalIdNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withCounterIds(COUNTER_ID)
                                .withPriorityGoals(prioiityGoals)
                                .withBiddingStrategy(strategyMap))),
                expectedResult);
    }
}
