package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.maximumclicks;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 19.11.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра WeeklySpendLimit при добавлении мобильной кампании со стратегией MaximumClicks")
@Tag(TagDictionary.TRUNK)
public class StrategyMaximumClicksWeeklySpendLimitNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    private static final Money minLimit = moneyCurrency.getMinWeeklyBudgetAmount();
    private static final Money maxLimit = moneyCurrency.getMaxWeeklyBudgetAmount();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public StrategyMaximumClicksAddMap params;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Нулевое значение", new StrategyMaximumClicksAddMap().withWeeklySpendLimit(0L),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
                {"Отрицательное значение", new StrategyMaximumClicksAddMap().withWeeklySpendLimit(-1L),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
                {"Значение меньше минимального",
                        new StrategyMaximumClicksAddMap().withWeeklySpendLimit(
                                minLimit.getPrevious().bidLong().longValue()),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
                {"Значение больше максимального",
                        new StrategyMaximumClicksAddMap().withWeeklySpendLimit(
                                maxLimit.getNext().bidLong().longValue()),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.WEEKLY_LIMIT_IS_TOO_HIGH,
                                maxLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
                {"Значение бюджета меньше максимальной ставки",
                        new StrategyMaximumClicksAddMap()
                                .withWeeklySpendLimit(minLimit.bidLong().longValue())
                                .withBidCeiling(MoneyCurrency.get(currency).getMaxPrice().bidLong().longValue()),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.WEEKLY_BUDGET_MUST_BE_GREATER_THAN_MAXIMUM_BID))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("139")
    public void weeklyLimitNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(
                                                        DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                                .withWbMaximumClicks(params))
                                        .withNetwork(
                                                new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                expectedResult);
    }
}
