package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.maximumconversionrate;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumConversionRateAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumConversionRateAddMap.MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка обновлении стратегии на MaximumConversionRate с установкой оптимизации по ключевым целям")
public class StrategyMaximumConversionRateMeaningfulGoalIdDbTest {
    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static final String client = CampaignsLogins.CLIENT;
    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);
    private static final Money weeklyLimit = MoneyCurrency.get(Currency.RUB).getMaxPrice().multiply(2L).bidLong();
    private static final Integer COUNTER_ID = 32265784;
    private static final Long GOAL_ID = 13088934L;
    private static Long campaignId;
    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void settingRoiPriorityGoalsOptimizationAndPriorityGoalsTest() {
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withCounterIds(COUNTER_ID)
                                .withPriorityGoals(new PriorityGoalsItemMap()
                                        .withGoalId(GOAL_ID)
                                        .withValue(13_000_000L))
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                                                .withWbMaximumConversionRate(new StrategyMaximumConversionRateAddMap()
                                                        .withWeeklySpendLimit(weeklyLimit.longValue())
                                                        .withGoalId(MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID)))
                                        .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                ExpectedResult.success());

        assumeThat("получили результаты добавления кампании", response.getAddResults(), hasSize(1));
        campaignId = response.getAddResults().get(0).getId();

        assertThat("campaigns.strategy_data.goal_id соответствует ожиданиям",
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campaignsSteps()
                        .getCampaignById(campaignId).getStrategyData().getAsJsonObject().get("goal_id").getAsLong(),
                equalTo(MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID));
    }

}
