package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.payforconversioncrr;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionCrrAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии создания до со стратегией PayForConversionCrr")
public class StrategyPayForConversionCrrNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Integer COUNTER_ID = MetrikaGoals.getCounterForLogin(client);
    private static final Money MIN_LIMIT = MoneyCurrency.get(Currency.RUB).getMinWeeklyBudgetAmount();
    private static final Money MAX_LIMIT = MoneyCurrency.get(Currency.RUB).getMaxWeeklyBudgetAmount();

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public StrategyPayForConversionCrrAddMap strategyData;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {
                        "ДРР меньше 1%",
                        new StrategyPayForConversionCrrAddMap()
                                .withCrr(StrategyPayForConversionCrrAddMap.MIN_CRR - 1)
                                .withWeeklySpendLimit(StrategyPayForConversionCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT)
                                .withGoalId(MetrikaGoals.getGoalForCounter(COUNTER_ID)),
                        ExpectedResult.errorWithCode(4000),
                },
                {
                        "ДРР больше 500%",
                        new StrategyPayForConversionCrrAddMap()
                                .withCrr(StrategyPayForConversionCrrAddMap.MAX_CRR + 1)
                                .withWeeklySpendLimit(StrategyPayForConversionCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT)
                                .withGoalId(MetrikaGoals.getGoalForCounter(COUNTER_ID)),
                        ExpectedResult.errorWithCode(4000),
                },
                {
                        "Бюджет меньше минимального значения",
                        new StrategyPayForConversionCrrAddMap()
                                .withCrr(StrategyPayForConversionCrrAddMap.DEFAULT_CRR)
                                .withWeeklySpendLimit(MIN_LIMIT.getPrevious().bidLong().longValue())
                                .withGoalId(MetrikaGoals.getGoalForCounter(COUNTER_ID)),
                        ExpectedResult.errorWithCode(4000),
                },
                {
                        "Бюджет больше максимального значения",
                        new StrategyPayForConversionCrrAddMap()
                                .withCrr(StrategyPayForConversionCrrAddMap.DEFAULT_CRR)
                                .withWeeklySpendLimit(MAX_LIMIT.getNext().bidLong().longValue())
                                .withGoalId(MetrikaGoals.getGoalForCounter(COUNTER_ID)),
                        ExpectedResult.errorWithCode(4000),
                },
                {
                        "Цель не задана",
                        new StrategyPayForConversionCrrAddMap()
                                .withCrr(StrategyPayForConversionCrrAddMap.DEFAULT_CRR)
                                .withWeeklySpendLimit(StrategyPayForConversionCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT),
                        ExpectedResult.errorWithCode(4000),
                },
                {

                        "Цель по всем КЦ",
                        new StrategyPayForConversionCrrAddMap()
                                .withCrr(StrategyPayForConversionCrrAddMap.DEFAULT_CRR)
                                .withWeeklySpendLimit(StrategyPayForConversionCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT)
                                .withGoalId(StrategyPayForConversionCrrAddMap.MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.NOT_SUITABLE_MEANINGFUL_GOALS)),
                }
        };
        return Arrays.asList(data);
    }

    @Test
    public void shouldReturnError() {
        DynamicTextCampaignStrategyAddMap strategyMap = new DynamicTextCampaignStrategyAddMap()
                .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION_CRR)
                        .withPayForConversionCrr(strategyData)
                ).withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff());

        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withCounterIds(COUNTER_ID)
                                .withBiddingStrategy(strategyMap)
                        )
                ),
                expectedResult
        );
    }
}
