package ru.yandex.autotests.direct.api.campaigns.add.mobilecampaign;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-161849")
@Features(CampaignsFeatures.ADD)
@Description("Проверка полей в таблице campaigns_mobile_content в БД при добавлении РМП кампании")
public class CampaignsMobileContentAddDbTest {
    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;
    private Long campaignId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
    }

    @Test
    public void checkCampaignsMobileContentDbValue() {
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultMobileAppCampaign());

        assertThat("campaigns_mobile_content.is_installed_app null",
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampaignsMobileContent(campaignId).getIsInstalledApp(), nullValue());

         assertThat("campaigns_mobile_content.device_type_targeting null",
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampaignsMobileContent(campaignId).getDeviceTypeTargeting(), nullValue());

         assertThat("campaigns_mobile_content.network_targeting null",
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampaignsMobileContent(campaignId).getNetworkTargeting(), nullValue());

         assertThat("campaigns_mobile_content.mobile_app_id null",
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampaignsMobileContent(campaignId).getMobileAppId(), equalTo(0L));
    }

}
