package ru.yandex.autotests.direct.api.campaigns.add.mobilecampaign.settings;

import java.util.Arrays;
import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsAutooptimization;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка не поддерживаемых значений поля Settings в мобильных кампаниях")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
@ParametersAreNonnullByDefault
public class AddDeprecatedSettingsTest {
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final String LOGIN = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public MobileAppCampaignSettingsEnum option;

    @Parameterized.Parameter(1)
    public YesNoEnum settingValue;

    @Parameterized.Parameters(name = "option = {0}, value = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                // DIRECT-63109
                {MobileAppCampaignSettingsEnum.ENABLE_AUTOFOCUS, YesNoEnum.NO},
                {MobileAppCampaignSettingsEnum.ENABLE_AUTOFOCUS, YesNoEnum.YES},
                // DIRECT-69528
                {MobileAppCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING, YesNoEnum.NO},
                {MobileAppCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING, YesNoEnum.YES}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("146")
    public void checkSettingsTest() {
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(
                        new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                                        .defaultMobileAppCampaign()
                                        .withSettings(new MobileAppCampaignSettingMap()
                                                .withOption(option)
                                                .withValue(settingValue)))),
                ExpectedResult.warningsIgnoringDetailsAndMessage(
                        new Notification(10163, Api5ErrorDetails.CAMPAIGN_SETTING_DEPRECATED, option)));

        Long campaignId = response.getAddResults().get(0).getId();

        CampaignsAutooptimization autoOptimization =
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).campaignsSteps()
                        .getCampaignById(campaignId).getAutooptimization();
        assertThat("кампания создалась с правильным значением настройки", autoOptimization,
                equalTo(CampaignsAutooptimization.No));
    }
}
