package ru.yandex.autotests.direct.api.campaigns.add.mobilecampaign.settings;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSettingMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 30.09.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка настройки REQUIRE_SERVICING поля Settings в мобильной кампании")
@RunWith(Parameterized.class)
public class AddManagerAssistanceTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long campaignID;
    private GetResponse getResponse;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameter(1)
    public YesNoEnum settingValue;

    @Parameterized.Parameter(2)
    public YesNoEnum expectedValue;

    @Parameterized.Parameters(name = "login = {0}, value = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsLogins.SERV_CLIENT, YesNoEnum.NO, YesNoEnum.NO},
                {CampaignsLogins.SERV_CLIENT, YesNoEnum.YES, YesNoEnum.YES},
                {CampaignsLogins.GET_CLIENT, YesNoEnum.NO, YesNoEnum.NO},
                {CampaignsLogins.GET_CLIENT, YesNoEnum.YES, YesNoEnum.NO}
        };
        return Arrays.asList(data);
    }

    @Before
    public void addCampaign() {
        campaignID = api.as(login).userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                                .defaultMobileAppCampaign()
                                .withSettings(new MobileAppCampaignSettingMap()
                                        .withOption(MobileAppCampaignSettingsEnum.REQUIRE_SERVICING)
                                        .withValue(settingValue))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("147")
    public void checkSettings() {
        getResponse = api.as(login).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignID))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum.SETTINGS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), hasSize(1));
        assumeThat("вернулись текстовые параметры кампании", getResponse.getCampaigns().get(0).getMobileAppCampaign(),
                notNullValue());
        List<MobileAppCampaignSettingGet> settings =
                getResponse.getCampaigns().get(0).getMobileAppCampaign().getSettings();
        assumeThat("вернулись Settings кампании", settings, notNullValue());

        List<YesNoEnum> value = settings.stream()
                .filter(setting -> setting.getOption().equals(MobileAppCampaignSettingsGetEnum.REQUIRE_SERVICING))
                .map(setting -> setting.getValue()).collect(Collectors.toList());
        assertThat("вернулся ожидаемый параметр", value, equalTo(Arrays.asList(expectedValue)));
    }
}
