package ru.yandex.autotests.direct.api.campaigns.add.mobilecampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 05.10.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Позитивные сценарии создания мобильной кампании с автоматическими стратегиями для Network")
@Tag(TagDictionary.TRUNK)
public class StrategyCombinationsAutoNetworkTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MobileAppCampaignStrategyAddMap strategyMap;
    private static MobileAppCampaignStrategyMap expectedStrategyMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public MobileAppCampaignNetworkStrategyAddMap networkStrategy;

    @Parameterized.Parameter(value = 2)
    public MobileAppCampaignNetworkStrategyMap expectedNetworkStrategy;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-45818
                {"AverageCpc",
                        new MobileAppCampaignNetworkStrategyAddMap().defaultAverageCpc(currency),
                        new MobileAppCampaignNetworkStrategyMap().defaultAverageCpc(currency)},
                {"MaximumClicks",
                        new MobileAppCampaignNetworkStrategyAddMap().defaultWbMaximumClicks(currency),
                        new MobileAppCampaignNetworkStrategyMap().defaultWbMaximumClicks(currency)}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        strategyMap = new MobileAppCampaignStrategyAddMap()
                .withSearch(new MobileAppCampaignSearchStrategyAddMap().defaultServingOff())
                .withNetwork(networkStrategy);
        expectedStrategyMap = new MobileAppCampaignStrategyMap()
                .withSearch(new MobileAppCampaignSearchStrategyMap().defaultServingOff())
                .withNetwork(expectedNetworkStrategy);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("148")
    public void strategyNetworkTest() {
        List<Long> ids = api.userSteps.campaignSteps().campaignsAddWithCheck(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                        .withBiddingStrategy(strategyMap)));
        assumeThat("создана кампания", ids, hasSize(1));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(ids.get(0)))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        MobileAppCampaignStrategy actualStrategy = campaigns.get(0).getMobileAppCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((MobileAppCampaignStrategy) expectedStrategyMap.getBean()));
    }
}
