package ru.yandex.autotests.direct.api.campaigns.add.mobilecampaign.strategy;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 05.10.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии добавления кампаний со стратегиями, которые не сочетаются друг с другом")
@Tag(TagDictionary.TRUNK)
public class StrategyCombinationsNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public MobileAppCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public MobileAppCampaignNetworkStrategyAddMap networkStrategy;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //отключено на поиске и на сети
                {"ServingOff + ServingOff",
                        new MobileAppCampaignSearchStrategyAddMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultServingOff()},
                //отключено на поиске и NetworkDefault на сети
                {"ServingOff + NetworkDefault",
                        new MobileAppCampaignSearchStrategyAddMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultNetworkDefault()},
                //ручная стратегия на поиске и автоматическая на сети
                {"HighestPosition + AverageCpc",
                        new MobileAppCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultAverageCpc(currency)},
                //автоматическая стратегия на поиске и автоматическая на сети
                {"MaximumClicks + AverageCpc",
                        new MobileAppCampaignSearchStrategyAddMap().defaultWbMaximumClicks(currency),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultAverageCpc(currency)},
                //автоматическая стратегия на поиске и MaximumCoverage на сети
                {"MaximumClicks + MaximumCoverage",
                        new MobileAppCampaignSearchStrategyAddMap().defaultWbMaximumClicks(currency),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultMaximumCoverage()}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("151")
    public void strategyCombinationNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                ExpectedResult.errorsIgnoringDetails(
                        new Notification(4000, Api5ErrorDetails.STRATEGIES_NOT_COMPATIBLE)));
    }
}
