package ru.yandex.autotests.direct.api.campaigns.add.mobilecampaign.strategy.maximumclicks;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 05.10.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра BidCeiling при добавлении мобильной кампании со стратегией MaximumClicks")
@Tag(TagDictionary.TRUNK)
public class StrategyMaximumClicksBidCeilingNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    private static final Money minValue = moneyCurrency.getMinPrice();
    private static final Money maxValue = moneyCurrency.getMaxPrice();
    private static final Money weeklyLimit = maxValue.multiply(2L).bidLong();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long bidCeiling;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Нулевое значение", 0L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.MAX_BID_SHOULD_BE_MORE_THAN,
                                minValue.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
                {"Отрицательное значение", -1L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.MAX_BID_SHOULD_BE_MORE_THAN,
                                minValue.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
                {"Значение меньше минимального", minValue.getPrevious().bidLong().longValue(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.MAX_BID_SHOULD_BE_MORE_THAN,
                                minValue.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
                {"Значение больше максимального", maxValue.getNext().bidLong().longValue(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.MAX_BID_SHOULD_BE_LESS_THAN,
                                maxValue.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("160")
    public void bidCeilingNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                        .withSearch(new MobileAppCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(
                                                        MobileAppCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                                                        .withWeeklySpendLimit(weeklyLimit.longValue())
                                                        .withBidCeiling(bidCeiling)))
                                        .withNetwork(new MobileAppCampaignNetworkStrategyAddMap()
                                                .defaultNetworkDefault())))),
                expectedResult);
    }
}
