package ru.yandex.autotests.direct.api.campaigns.add.mobilecampaign.strategy.networkdefault;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 05.10.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Проверка допустимых значений параметра LimitPercent при добавлении мобильной кампании со стратегией " +
        "NetworkDefault")
@Tag(TagDictionary.TRUNK)
public class StrategyNetworkDefaultTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;

    private MobileAppCampaignStrategyAddMap strategyMap;

    private MobileAppCampaignNetworkStrategyMap expectedContextStrategyMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String searchStrategyDescription;

    @Parameterized.Parameter(value = 1)
    public Integer limitPercent;

    @Parameterized.Parameter(value = 2)
    public MobileAppCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameters(name = "search = {0}, limit = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //Ручная стратегия на Search
                {"Ручная", null,
                        new MobileAppCampaignSearchStrategyAddMap().defaultAverageCpc(currency)},
                {"Ручная", 40,
                        new MobileAppCampaignSearchStrategyAddMap().defaultAverageCpc(currency)},
                {"Ручная", 10,
                        new MobileAppCampaignSearchStrategyAddMap().defaultAverageCpc(currency)},
                {"Ручная", 100,
                        new MobileAppCampaignSearchStrategyAddMap().defaultAverageCpc(currency)},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        strategyMap = new MobileAppCampaignStrategyAddMap()
                .withSearch(searchStrategy)
                .withNetwork(new MobileAppCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                        .withNetworkDefault(new StrategyNetworkDefaultAddMap()
                                .withLimitPercent(limitPercent)));
        expectedContextStrategyMap = new MobileAppCampaignNetworkStrategyMap()
                .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("165")
    public void networkDefaultTest() {
        //DIRECT-47601
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                                .withBiddingStrategy(strategyMap))),
                // Указывать для автобюджетных стратегий LimitPercent не имеет смысла
                limitPercent == null
                        ? ExpectedResult.success()
                        : ExpectedResult.warnings(new Notification(10165,
                        Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED, capitalize(
                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT))));
        assumeThat("получили результаты добавления кампании", response.getAddResults(), hasSize(1));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(response.getAddResults().get(0).getId()))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        MobileAppCampaignStrategy actualStrategy = campaigns.get(0).getMobileAppCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        assertThat("получили корректную стратегию для Network", actualStrategy.getNetwork(),
                beanDifferV5((MobileAppCampaignNetworkStrategy) expectedContextStrategyMap.getBean()));
    }
}
