package ru.yandex.autotests.direct.api.campaigns.add.mobilecampaign.strategy.payforinstall;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForInstallAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметров AverageCpi и WeeklySpendLimit при добавлении кампании со " +
        "стратегией PayForInstall")
//todo после появления переводов в танкере обновить переводы в монге
public class StrategyPayForInstallNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static final MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);
    private static final int PAY_FOR_INSTALL_SUM_TO_AVG_CPA_MIN_RATIO = 20;

    private static final Money minPrice = moneyCurrency.getMinAveragePrice();
    private static final Money maxPrice = moneyCurrency.getMaxPayForConversionCpa();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public StrategyPayForInstallAddMap params;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Нулевое значение", new StrategyPayForInstallAddMap().withAverageCpi(0L),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.AVERAGE_CPI_SHOULD_BE_MORE_THAN,
                                minPrice.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
                {"Отрицательное значение", new StrategyPayForInstallAddMap().withAverageCpi(-1L),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.AVERAGE_CPI_SHOULD_BE_MORE_THAN,
                                minPrice.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
                {"Значение меньше минимального",
                        new StrategyPayForInstallAddMap().withAverageCpi(minPrice.getPrevious().bidLong().longValue()),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.AVERAGE_CPI_SHOULD_BE_MORE_THAN,
                                minPrice.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
                {"Значение больше максимального",
                        // умножаем на 3, потому что включена фича increased_cpa_limit_for_pay_for_conversion
                        new StrategyPayForInstallAddMap().withAverageCpi(
                                maxPrice.multiply(3).getNext().bidLong().longValue()),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.AVERAGE_CPI_SHOULD_BE_NO_MORE_THAN,
                                maxPrice.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription()))},
                {"Среднее значение ставки больше недельного бюджета",
                        new StrategyPayForInstallAddMap()
                                .withAverageCpi(
                                        MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().getNext().bidLong()
                                                .longValue())
                                .withWeeklySpendLimit(
                                MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().bidLong().longValue()),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.WEEKLY_BUDGET_SHOULD_BE_GREATER_THAN_AVERAGE_CPI))},
                // TODO: разобраться в https://st.yandex-team.ru/DIRECT-161540
//                {"Среднее значение ставки * 20 больше недельного бюджета",
//                        new StrategyPayForInstallAddMap()
//                                .withAverageCpi(
//                                        MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().divide(20).getNext()
//                                                .bidLong().longValue())
//                                .withWeeklySpendLimit(
//                                MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().bidLong().longValue()),
//                        ExpectedResult.errors(new Notification(4000,
//                                Api5ErrorDetails.WEEKLY_BUDGET_MUST_BE_GREATER_THAN_AVG_CPA_MULTIPLIED_BY_RATIO,
//                                PAY_FOR_INSTALL_SUM_TO_AVG_CPA_MIN_RATIO))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void payForInstallNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                        .withSearch(new MobileAppCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(
                                                        MobileAppCampaignSearchStrategyTypeEnum.PAY_FOR_INSTALL)
                                                .withPayForInstall(params))
                                        .withNetwork(new MobileAppCampaignNetworkStrategyAddMap()
                                                .defaultNetworkDefault())))),
                expectedResult);
    }
}
