package ru.yandex.autotests.direct.api.campaigns.add.negativekeywords;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.KeywordsSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 26.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля NegativeKeywords. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class NegativeKeywordsValidationPositiveTest {
    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] negativeKeywords;

    @Parameterized.Parameter(2)
    public String[] negativeKeywordsAfterSave;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        String maxLengthNegativeKeyword =
                RandomStringUtils.randomAlphabetic(KeywordsSteps.MINUS_WORD_MAX_LENGTH);
        return Arrays.asList(new Object[][]{
                {"One russian keyword", new String[]{"подарки"}, new String[]{"подарки"}},
                {"One english keyword", new String[]{"english"}, new String[]{"english"}},
                {"One maximum length keyword",
                        new String[]{maxLengthNegativeKeyword}, new String[]{maxLengthNegativeKeyword}},
                {"Maximum length keyword + special symbols", new String[]{"[" + maxLengthNegativeKeyword + "]"},
                        new String[]{"[" + maxLengthNegativeKeyword + "]"}},
                {"+test", new String[]{"+test"}, new String[]{"+test"}},
                {"!test", new String[]{"!test"}, new String[]{"!test"}},
                {"te.st", new String[]{"te.st"}, new String[]{"te st"}},
                {"test.", new String[]{"test."}, new String[]{"test"}},
                {"1test", new String[]{"1test"}, new String[]{"1test"}},
                {"te1st", new String[]{"te1st"}, new String[]{"te1st"}},
                {"test1", new String[]{"test1"}, new String[]{"test1"}},
                {" test", new String[]{" test"}, new String[]{"test"}},
                {"test ", new String[]{"test "}, new String[]{"test"}}
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("175")
    public void addWithNegativeKeywordsAndCheckSave() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem().withNegativeKeywords(negativeKeywords)
                                .withDefaultTextCampaign()
                        ),
                ExpectedResult.success());
        Long id = addResponse.getAddResults().get(0).getId();
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.NEGATIVE_KEYWORDS);
        assertThat("поле NegativeKeywords сохранилось верно", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withNegativeKeywords(negativeKeywordsAfterSave).getBean()));
    }
}
