package ru.yandex.autotests.direct.api.campaigns.add.notification;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.EmailSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 03.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля CheckPositionInterval в настройках нотификаций кампании при её создании")
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@RunWith(Parameterized.class)
public class EmailSettingsCheckPositionIntervalValidationTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public int checkPositionInterval;

    @Parameterized.Parameter(1)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "CheckPositionInterval = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {15, ExpectedResult.success()},
                {30, ExpectedResult.success()},
                {60, ExpectedResult.success()},
                {-1, ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                        Api5ErrorDetails.POSITION_INTERVAL_CAN_ONLY_BE))},
                {0, ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                        Api5ErrorDetails.POSITION_INTERVAL_CAN_ONLY_BE))},
                {14, ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                        Api5ErrorDetails.POSITION_INTERVAL_CAN_ONLY_BE))},
                {61, ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                        Api5ErrorDetails.POSITION_INTERVAL_CAN_ONLY_BE))},
        });
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("176")
    public void addCampaignWithNotificationCheckPositionInterval() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultTextCampaign()
                        .withNotification(new NotificationMap()
                                .defaultNotification()
                                .withEmailSettings(new EmailSettingsMap()
                                        .defaultEmailSettings()
                                        .withCheckPositionInterval(checkPositionInterval)))),
                expectedResult);
    }
}
