package ru.yandex.autotests.direct.api.campaigns.add.notification;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.EmailSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 04.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка значений по умолчанию в структуре Notification.EmailSettings")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class EmailSettingsDefaultValuesTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Проверка значения по умолчанию для поля WarningBalance")
    @ru.yandex.qatools.allure.annotations.TestCaseId("177")
    public void checkDefaultValueOfWarningBalance() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign()
                .withNotification(new NotificationMap()
                        .defaultNotification()
                        .withEmailSettings(new EmailSettingsMap()
                                .withWarningBalance(null))));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignId);
        assumeThat("была получена одна кампания", campaigns, hasSize(1));

        CampaignGetItem actualCampaign = campaigns.get(0);
        CampaignGetItem expectedCampaign = (CampaignGetItem) new CampaignGetItemMap()
                .withNotification(new NotificationMap()
                        .withEmailSettings(new EmailSettingsMap()
                                .withWarningBalance(20))).getBean();
        assertThat("значение WarningBalance соответствует ожидаемому",
                actualCampaign, beanEquivalent(expectedCampaign));
    }

    @Test
    @Description("Проверка значения по умолчанию для поля CheckPositionInterval")
    @ru.yandex.qatools.allure.annotations.TestCaseId("178")
    public void checkDefaultValueOfPositionInterval() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign()
                .withNotification(new NotificationMap()
                        .defaultNotification()
                        .withEmailSettings(new EmailSettingsMap()
                                .withCheckPositionInterval(null))));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignId);
        assumeThat("была получена одна кампания", campaigns, hasSize(1));

        CampaignGetItem actualCampaign = campaigns.get(0);
        CampaignGetItem expectedCampaign = (CampaignGetItem) new CampaignGetItemMap()
                .withNotification(new NotificationMap()
                        .withEmailSettings(new EmailSettingsMap()
                                .withCheckPositionInterval(60))).getBean();
        assertThat("значение CheckPositionInterval соответствует ожидаемому",
                actualCampaign, beanEquivalent(expectedCampaign));
    }

    @Test
    @Description("Проверка значения по умолчанию для поля SendAccountNews")
    @ru.yandex.qatools.allure.annotations.TestCaseId("179")
    public void checkDefaultValueOfSendAccountNews() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign()
                .withNotification(new NotificationMap()
                        .defaultNotification()
                        .withEmailSettings(new EmailSettingsMap()
                                .withSendAccountNews(null))));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignId);
        assumeThat("была получена одна кампания", campaigns, hasSize(1));

        CampaignGetItem actualCampaign = campaigns.get(0);
        CampaignGetItem expectedCampaign = (CampaignGetItem) new CampaignGetItemMap()
                .withNotification(new NotificationMap()
                        .withEmailSettings(new EmailSettingsMap()
                                .withSendAccountNews(YesNoEnum.NO))).getBean();
        assertThat("значение SendAccountNews соответствует ожидаемому",
                actualCampaign, beanEquivalent(expectedCampaign));
    }

    @Test
    @Description("Проверка значения по умолчанию для поля SendWarnings")
    @ru.yandex.qatools.allure.annotations.TestCaseId("180")
    public void checkDefaultValueOfSendWarnings() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign()
                .withNotification(new NotificationMap()
                        .defaultNotification()
                        .withEmailSettings(new EmailSettingsMap()
                                .withSendWarnings(null))));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignId);
        assumeThat("была получена одна кампания", campaigns, hasSize(1));

        CampaignGetItem actualCampaign = campaigns.get(0);
        CampaignGetItem expectedCampaign = (CampaignGetItem) new CampaignGetItemMap()
                .withNotification(new NotificationMap()
                        .withEmailSettings(new EmailSettingsMap()
                                .withSendWarnings(YesNoEnum.NO))).getBean();
        assertThat("значение SendWarnings соответствует ожидаемому",
                actualCampaign, beanEquivalent(expectedCampaign));
    }
}
