package ru.yandex.autotests.direct.api.campaigns.add.notification;

import java.util.Arrays;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.EmailSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 03.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля Email в настройках нотификаций кампании при её создании")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class EmailSettingsEmailValidationTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;
    private static final int MAX_EMAIL_USER_LENGTH_JAVA = 64;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String email;

    @Parameterized.Parameter(1)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "email = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"at-tester@yandex.ru", JavaOrPerlExpectedResult.both(ExpectedResult.success())},
                {"at-tester@yandex.rururururururur", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))
                        .perl(ExpectedResult.success())},
                {"at-tester@яндекс.аб", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))
                        .perl(ExpectedResult.success())},
                {"at-tester@яндекс.абвгдежзиклмноп", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))
                        .perl(ExpectedResult.success())},
                {"at-tester@123.a45", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))
                        .perl(ExpectedResult.success())},
                {"at-tester@сувеніри.укр", JavaOrPerlExpectedResult.both(ExpectedResult.success())},
                {"", JavaOrPerlExpectedResult
                        .both(ExpectedResult.errorsIgnoringDetails(new Notification(5003, Api5ErrorDetails.EMAIL_IS_EMPTY)))},
                {" ", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))
                        .perl(ExpectedResult.errors(new Notification(5003, Api5ErrorDetails.EMAIL_IS_EMPTY)))},
                {RandomStringUtils.randomAlphabetic(CampaignAddItemMap.MAX_EMAIL_LENGTH - 9) + "@yandex.ru",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(5004,
                                        Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))
                                .perl(ExpectedResult.errors(new Notification(5001,
                                Api5ErrorDetails.EMAIL_LENGTH_EXCEEDED, CampaignAddItemMap.MAX_EMAIL_LENGTH)))},
                {RandomStringUtils.randomAlphabetic(MAX_EMAIL_USER_LENGTH_JAVA + 1) + "@yandex.ru",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(5004,
                                        Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))
                                .perl(ExpectedResult.success())},
                {"at-tester@yandex.r",
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))},
                {"at-tester@yandex.rurururururururu",
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))},
                {"at-tester@яндекс.а",
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))},
                {"at-tester@яндекс.абвгдежзиклмнопр",
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))},
                {"at-tester@123.45",
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INCORRECT_EMAIL_FORMAT)))},
        });
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("181")
    public void addCampaignWithNotificationEmail() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultTextCampaign()
                        .withNotification(new NotificationMap()
                                .defaultNotification()
                                .withEmailSettings(new EmailSettingsMap()
                                        .defaultEmailSettings()
                                        .withEmail(email)))),
                expectedResult);
    }
}
